﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalStorage.Consoles
{
    /// <summary>
    /// <see cref="CommandBase"/> に渡す入出力コンソールを表現します。
    /// </summary>
    public abstract class CommandConsoleBase
    {
        /// <summary>
        /// メッセージを出力します。
        /// </summary>
        /// <param name="value">メッセージフォーマット</param>
        /// <param name="arg">フォーマットの引数</param>
        public void WriteToOut(string value, params object[] arg)
        {
            using (var writer = OpenOutputWriter())
            {
                writer.Write(value, arg);
            }
        }

        /// <summary>
        /// メッセージを出力します。
        /// </summary>
        /// <param name="value">メッセージフォーマット</param>
        /// <param name="arg">フォーマットの引数</param>
        public void WriteLineToOut(string value, params object[] args)
        {
            using (var writer = OpenOutputWriter())
            {
                writer.WriteLine(value, args);
            }
        }

        /// <summary>
        /// エラー出力へメッセージを出力します。
        /// </summary>
        /// <param name="value">メッセージフォーマット</param>
        /// <param name="arg">フォーマットの引数</param>
        public void WriteToError(string value, params object[] args)
        {
            using (var writer = OpenErrorWriter())
            {
                writer.Write(value, args);
            }
        }

        /// <summary>
        /// エラー出力へメッセージを出力します。
        /// </summary>
        /// <param name="value">メッセージフォーマット</param>
        /// <param name="arg">フォーマットの引数</param>
        public void WriteLineToError(string value, params object[] args)
        {
            using (var writer = OpenErrorWriter())
            {
                writer.WriteLine(value, args);
            }
        }

        protected abstract TextReader OpenInputReader();
        protected abstract TextWriter OpenOutputWriter();
        protected abstract TextWriter OpenErrorWriter();

        public abstract Stream OpenInputStream();
        public abstract Stream OpenOutputStream();
        public abstract Stream OpenErrorStream();
    }
}
