﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using GitExternalStorage.Configs;
using GitExternalStorage.Consoles;

namespace GitExternalStorage.Commands
{
    /// <summary>
    /// フックスクリプトをインストールします。
    /// </summary>
    public class InstallHookScriptCommand : CommandBase
    {
        public InstallHookScriptCommand()
            : base()
        {
        }

        public InstallHookScriptCommand(CommandConsoleBase console)
            : base(console)
        {
        }

        public override void Run()
        {
            this.InstallPrepushHookScript();
        }

        private void InstallPrepushHookScript()
        {
            CommandConsole.WriteLineToOut("Install pre-push hook script.");

            var gitRepository = Environments.GitRepository;

            var hookDir = Path.Combine(gitRepository.GetGitDirectory(), "hooks");
            var prepushHookScriptPath = Path.Combine(hookDir, "pre-push");
            var exstoragePrepushHookScriptPath = Path.Combine(hookDir, "pre-push.exstorage");

            if (!File.Exists(prepushHookScriptPath))
            {
                File.WriteAllBytes(prepushHookScriptPath, Resource.pre_push);
            }

            File.WriteAllBytes(exstoragePrepushHookScriptPath, Resource.pre_push_exstorage);
        }
    }
}
