﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalRepository.Repository.Svn
{
    public static class SvnCommandUtils
    {
        /// <summary>
        /// Svn コマンドを実行します。
        /// </summary>
        /// <param name="options">コマンドに与える引数</param>
        /// <returns>コマンドの標準出力結果</returns>
        public static string GetSvnOutput(string workingDirectory, string options)
        {
            return GetOutput("svn", workingDirectory, options);
        }

        /// <summary>
        /// Svn コマンドを実行します。
        /// </summary>
        /// <param name="options">コマンドに与える引数</param>
        public static void RunSvn(string workingDirectory, string options)
        {
            Run("svn", workingDirectory, options);
        }

        /// <summary>
        /// SvnAdmin コマンドを実行します。
        /// </summary>
        /// <param name="options">コマンドに与える引数</param>
        /// <returns>コマンドの標準出力結果</returns>
        public static string GetSvnAdminOutput(string workingDirectory, string options)
        {
            return GetOutput("svnadmin", workingDirectory, options);
        }

        /// <summary>
        /// SvnAdmin コマンドを実行します。
        /// </summary>
        /// <param name="options">コマンドに与える引数</param>
        public static void RunSvnAdmin(string workingDirectory, string options)
        {
            Run("svnadmin", workingDirectory, options);
        }

        /// <summary>
        /// SvnVersion コマンドを実行します。
        /// </summary>
        /// <param name="options">コマンドに与える引数</param>
        /// <returns>コマンドの標準出力結果</returns>
        public static string GetSvnVersionOutput(string workingDirectory, string options)
        {
            return GetOutput("svnversion", workingDirectory, options);
        }

        /// <summary>
        /// Svn コマンドを実行します。
        /// </summary>
        /// <param name="options">コマンドに与える引数</param>
        /// <returns>コマンドの標準出力結果</returns>
        private static string GetOutput(string svnCommand, string workingDirectory, string options)
        {
            try
            {
                return ProcessUtility.GetProcessOutput(svnCommand, options, workingDirectory).Trim();
            }
            catch (ProcessUtilityExitCodeNonZeroException e)
            {
                throw new SvnRepositoryCommandFailedException(string.Format("Faild to execute the command '{0}'.", svnCommand), e)
                {
                    Data = { { "Detail", string.Format("Failed to execute '{0} {1}'.", svnCommand, options) } }
                };
            }
            catch (ProcessUtilityWin32Exception e)
            {
                throw new SvnRepositoryCommandNotFoundException(string.Format("Not found the command '{0}'", svnCommand), e)
                {
                    Data = { { "Detail", string.Format("Not found the command '{0} {1}'.", svnCommand, options) } }
                };
            }
        }

        /// <summary>
        /// Svn コマンドを実行します。
        /// </summary>
        /// <param name="options">コマンドに与える引数</param>
        private static void Run(string svnCommand, string workingDirectory, string options)
        {
            try
            {
                ProcessUtility.RunProcess(svnCommand, options, workingDirectory);
            }
            catch (ProcessUtilityExitCodeNonZeroException e)
            {
                throw new SvnRepositoryCommandFailedException(string.Format("Faild to execute the command '{0}'.", svnCommand), e)
                {
                    Data = { { "Detail", string.Format("Failed to execute '{0} {1}'.", svnCommand, options) } }
                };
            }
            catch (ProcessUtilityWin32Exception e)
            {
                throw new SvnRepositoryCommandNotFoundException(string.Format("Not found the command '{0}'", svnCommand), e)
                {
                    Data = { { "Detail", string.Format("Not found the command '{0} {1}'.", svnCommand, options) } }
                };
            }
        }
    }
}
