﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalRepository.Repository.Git
{
    /// <summary>
    /// git のコンフィグのセクションを表現します。
    /// </summary>
    public class GitConfigSection
    {
        /// <summary>
        /// セクション名です。
        /// </summary>
        public string Section { get; set; }

        /// <summary>
        /// サブセクション名です。
        /// </summary>
        public string SubSection { get; set; }

        /// <summary>
        /// セクションに属するすべてのエントリです。
        /// </summary>
        public Dictionary<string, string> Entries { get; set; }

        public GitConfigSection()
        {
            this.Entries = new Dictionary<string, string>();
        }
    }

    /// <summary>
    /// セクションに属するエントリを表現します。
    /// </summary>
    public class GitConfigSectionEntry
    {
        /// <summary>
        /// エントリ名です。
        /// </summary>
        public string Entry { get; set; }

        /// <summary>
        /// 値です。
        /// </summary>
        public string Value { get; set; }
    }
}
