﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/utilTool/utilTool_ConverterUtil.h>

namespace nn { namespace utilTool {

const nn::util::string_view ConverterUtil::g_Spaces = nn::util::string_view( " " );

void ConverterUtil::Parse( float* pData, const char* nptr, char** endptr /*= NULL*/ ) NN_NOEXCEPT
{
    *pData = static_cast< float >( std::strtod( nptr, endptr ) );
}

void ConverterUtil::Parse( int* pData, const char* nptr, char** endptr /*= NULL*/ ) NN_NOEXCEPT
{
    *pData = std::strtol( nptr, endptr, 10 );
}

void ConverterUtil::Parse( char* pData, const char* nptr, char** endptr /*= NULL*/ ) NN_NOEXCEPT
{
    *pData = static_cast< char >( std::strtoul( nptr, endptr, 16 ) );
}

void ConverterUtil::Parse( bool* pData, const char* nptr, char** endptr /*= NULL*/ ) NN_NOEXCEPT
{
    // 空白文字区切りで最初のトークンが "false" か "FALSE" との一致で判定します。
    nn::util::string_view str( nptr );
    str = str.substr( str.find_first_not_of( g_Spaces ) );
    str = str.substr( 0, str.find_first_of( g_Spaces ) );
    if ( endptr )
    {
        *endptr = const_cast< char* >( &*str.end() );
    }

    *pData = ( str.compare( "false" ) != 0 ) && ( str.compare( "FALSE" ) != 0 );
}

}} // namespace nn::utilTool
