﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Middleware.h>
#include <nn/nn_Version.h>

#if 1
#define NN_DETAIL_FS_MACRO_TO_STRING(x) NN_DETAIL_FS_MACRO_TO_STRING_(x)
#define NN_DETAIL_FS_MACRO_TO_STRING_(x) #x

// NW4F_1_10_0_module_name のような文字列を作るマクロ
#define NW_MIDDLEWARE_SYMBOL(build_option) "NintendoSdk_nnSdk-" NN_DETAIL_FS_MACRO_TO_STRING(NN_NX_ADDON_VERSION_MAJOR) "_" NN_DETAIL_FS_MACRO_TO_STRING(NN_NX_ADDON_VERSION_MINOR) "_" NN_DETAIL_FS_MACRO_TO_STRING(NN_NX_ADDON_VERSION_MICRO) "-" #build_option

#if defined(NN_SDK_BUILD_DEBUG)
NN_DEFINE_MIDDLEWARE( g_MiddlewareInfo1, "Nintendo", NW_MIDDLEWARE_SYMBOL(Debug) );
#elif defined(NN_SDK_BUILD_DEVELOP)
NN_DEFINE_MIDDLEWARE( g_MiddlewareInfo1, "Nintendo", NW_MIDDLEWARE_SYMBOL(Develop) );
#elif defined(NN_SDK_BUILD_RELEASE)
NN_DEFINE_MIDDLEWARE( g_MiddlewareInfo1, "Nintendo", NW_MIDDLEWARE_SYMBOL(Release) );
#endif
#endif

//NN_DEFINE_MIDDLEWARE( g_MiddlewareInfo1, "NINTENDO", "LIDBE-1_0_0" );

namespace nn { namespace util {

    void SdkVersion() NN_NOEXCEPT
    {
        NN_USING_MIDDLEWARE( g_MiddlewareInfo1 );
        return;
    }

}}  // namespace nn::util

