﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_Config.h>

#if !defined(NN_BUILD_CONFIG_COMPILER_SUPPORTS_VC)
    #error  "VC++ コンパイラーが利用出来るビルド条件ではありません。"
#endif

#include <cstdio>
#include "util_FormatStringImpl.h"

namespace nn { namespace util { namespace detail {

void ConvertToExponentStyleStringWithPoint(char* buffer, size_t bufferLength, double value, int precision) NN_NOEXCEPT
{
    // 確実に小数点を出力するために # フラグを指定する
    _snprintf_s(buffer, bufferLength, _TRUNCATE, "%#.*e", precision, value);
}

}}}
