﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/edid/edid_DisplayMode.h>
#include <nn/edid/edid_Polarity.h>
#include <nn/edid/edid_SyncType.h>
#include "../cea861/edid_Cea861.h"

namespace nn { namespace edid { namespace detail {

    void VisitEstablishedTiming(DisplayModeVisitor visitor, void* pUserData, int width, int height, float refreshRate, bool isInterlaced) NN_NOEXCEPT;

    void GetEstablishedTimingI(DisplayModeVisitor visitor, void* pUserData, std::uint8_t timings) NN_NOEXCEPT;
    void GetEstablishedTimingII(DisplayModeVisitor visitor, void* pUserData, std::uint8_t timings) NN_NOEXCEPT;
    void GetEstablishedTimingIII(DisplayModeVisitor visitor, void* pUserData, std::uint8_t timings) NN_NOEXCEPT;

    void GetStandardTiming(DisplayModeInfo* pOutMode, std::uint8_t pixels, std::uint8_t timing) NN_NOEXCEPT;
    void GetStandardTimingAspectRatio(int* pOutWidth, int* pOutHeight, std::uint8_t timing) NN_NOEXCEPT;

    const int DetailedTimingStride = 18;

    Polarity GetDetailedTimingVsyncPolarity(std::uint8_t features) NN_NOEXCEPT;
    Polarity GetDetailedTimingHsyncPolarity(std::uint8_t features) NN_NOEXCEPT;
    StereoMode GetDetailedTimingStereoMode(std::uint8_t features) NN_NOEXCEPT;
    SyncTypeSet GetDetailedTimingSyncTypes(std::uint8_t features) NN_NOEXCEPT;
    bool IsDetailedTimingSerrated(std::uint8_t features) NN_NOEXCEPT;
    bool IsDetailedTimingInterlaced(std::uint8_t features) NN_NOEXCEPT;

    bool GetDetailedTiming(DisplayModeInfo* pOutMode, DisplayTimingInfo* pOutTiming, ImageSizeInfo* pOutImage, const std::uint8_t* pDetailedTiming, size_t size) NN_NOEXCEPT;

    struct DetailedTimingVisitorData
    {
        DisplayModeVisitor visitor;
        void* pUserData;
    };

    bool DetailedTimingVisitor(const DisplayModeInfo* pMode, const DisplayTimingInfo* pTiming, const ImageSizeInfo* pImage, void* pUserData) NN_NOEXCEPT;
    bool ModeExtensionBlockVisitor(const std::uint8_t* pBlock, size_t size, void* pUserData) NN_NOEXCEPT;
    bool VideoBlockVisitor(const std::uint8_t* pBlock, size_t size, cea861::BlockTag tag, void* pUserData) NN_NOEXCEPT;

}}}
