﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/nn_Macro.h>
#include <nn/edid/edid_Audio.h>
#include <nn/edid/edid_VideoInterface.h>
#include <nn/edid/edid_SyncLevel.h>
#include <nn/edid/edid_BlankLevel.h>
#include <nn/edid/edid_SyncType.h>
#include <nn/edid/edid_ColorDepth.h>
#include "../cea861/edid_Cea861.h"


namespace nn { namespace edid { namespace detail {

    struct AudioFormatVisitorData
    {
        nn::edid::AudioFormatVisitor visitor;
        void* pUserData;
    };

    bool AudioDataVisitor(const std::uint8_t* pBlock, size_t size, void* pUserData) NN_NOEXCEPT;
    bool AudioDataBlockVisitor(const std::uint8_t* pBlock, size_t size, cea861::BlockTag tag, void* pUserData) NN_NOEXCEPT;

}}}
