﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/edid/edid_AudioFormatInfo.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include "edid_AudioMode.h"
#include "edid_Serialize.h"

bool nn::edid::detail::AudioDataVisitor(const std::uint8_t* pBlock, size_t size, void* pUserData) NN_NOEXCEPT
{

    cea861::VisitDataBlocks(pBlock, size, AudioDataBlockVisitor, pUserData);

    return true;
}

bool nn::edid::detail::AudioDataBlockVisitor(const std::uint8_t* pBlock, size_t size, cea861::BlockTag tag, void* pUserData) NN_NOEXCEPT
{

    switch( tag )
    {
    case cea861::BlockTag::Audio:
        {
            for(int i = 1; i + 3 <= static_cast<int>(size); i += 3)
            {
                AudioFormatInfo data;
                switch((pBlock[i] >> 3) & 0xF)
                {
                    case 1:
                        data.format = nn::edid::AudioFormat_Pcm;
                        break;
                    case 2:
                        data.format = nn::edid::AudioFormat_Ac3;
                        break;
                    case 3:
                        data.format = nn::edid::AudioFormat_Mpeg1;
                        break;
                    case 4:
                        data.format = nn::edid::AudioFormat_Mp3;
                        break;
                    case 5:
                        data.format = nn::edid::AudioFormat_Mpeg2;
                        break;
                    case 6:
                        data.format = nn::edid::AudioFormat_AacLc;
                        break;
                    case 7:
                        data.format = nn::edid::AudioFormat_Dts;
                        break;
                    case 8:
                        data.format = nn::edid::AudioFormat_Atrac;
                        break;
                    case 9:
                        data.format = nn::edid::AudioFormat_Dsd;
                        break;
                    case 10:
                        data.format = nn::edid::AudioFormat_EAc3;
                        break;
                    case 11:
                        data.format = nn::edid::AudioFormat_DtsHd;
                        break;
                    case 12:
                        data.format = nn::edid::AudioFormat_Mlp;
                        break;
                    case 13:
                        data.format = nn::edid::AudioFormat_Dst;
                        break;
                    case 14:
                        data.format = nn::edid::AudioFormat_WmaPro;
                        break;
                    case 15:
                        if ((pBlock[i + 2] >> 3) == 1)
                            data.format = nn::edid::AudioFormat_HeAac;
                        else if ((pBlock[i + 2] >> 3) == 2)
                            data.format = nn::edid::AudioFormat_HeAacV2;
                        else if ((pBlock[i + 2] >> 3) == 3)
                            data.format = nn::edid::AudioFormat_MpegSurround;
                        break;
                    default:
                        break;
                }
                data.channelCountMax = (pBlock[i] & 0x7) + 1;

                if(pBlock[i + 1] & 0x40)
                        data.samplingRates.Set<Sampling::Rate192Khz>();
                if(pBlock[i + 1] & 0x20)
                        data.samplingRates.Set<Sampling::Rate176_4Khz>();
                if(pBlock[i + 1] & 0x10)
                        data.samplingRates.Set<Sampling::Rate96Khz>();
                if(pBlock[i + 1] & 0x8)
                        data.samplingRates.Set<Sampling::Rate88_2Khz>();
                if(pBlock[i + 1] & 0x4)
                        data.samplingRates.Set<Sampling::Rate48Khz>();
                if(pBlock[i + 1] & 0x2)
                        data.samplingRates.Set<Sampling::Rate44_1Khz>();
                if(pBlock[i + 1] & 0x1)
                        data.samplingRates.Set<Sampling::Rate32Khz>();

                AudioFormatVisitorData* pData = static_cast<AudioFormatVisitorData*>(pUserData);
                pData->visitor(&data, pData->pUserData);
            }
        }
        break;
    default:
        break;
    }
    return true;
}
