﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/nn_SdkAssert.h>
#include <nn/crypto/detail/crypto_GhashImpl.h>
#include <nn/crypto/detail/crypto_Clear.h>
#include "crypto_Util.h"
#include "crypto_UpdateImpl.h"

namespace nn { namespace crypto { namespace detail {

GhashImpl::~GhashImpl() NN_NOEXCEPT
{
    ClearMemory(this, sizeof(*this));
}

void GhashImpl::Reset() NN_NOEXCEPT
{
    m_Ghash.as128.Zero();
    m_BufferedByte = 0;
    m_MessageSizeHi = 0;
    m_MessageSizeLo = 0;

    m_State = State_ProcessingData;
}

void GhashImpl::ProcessPadding() NN_NOEXCEPT
{
    // 現在の入力ブロックにゼロをパディングして入力を完了させる
    // それはつまり、GHASH 計算を行うことと同義
    if (m_BufferedByte > 0)
    {
        GfMultH(&m_Ghash);
        m_BufferedByte = 0;
    }
}

void GhashImpl::SwitchMessageSizeDigit() NN_NOEXCEPT
{
    // 現在のメッセージサイズを上位桁に移して、下位桁で新たにサイズとして累積させていく
    NN_SDK_REQUIRES(m_MessageSizeHi == 0);

    m_MessageSizeHi = m_MessageSizeLo;
    m_MessageSizeLo = 0;
}

}}} // namespace nn::crypto::detail
