﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief msgpack に関する API の宣言
 */

/**
    @namespace  nn::msgpack
    @brief      msgpack シリアライザライブラリの名前空間です。

    @details
 */
#define __STDC_LIMIT_MACROS
#define __STDC_CONSTANT_MACROS
#define __STDC_FORMAT_MACROS
#define _USE_MATH_DEFINES
#define NLIB_NAMESPACE_BEGIN namespace nne { namespace nlib {
#define NLIB_NS ::nne::nlib

#include <nn/nlib/msgpack/msgpack.h>
#include <nn/nlib/msgpack/MpDirectWriter.h>
#include <nn/nlib/msgpack/MpWalker.h>
#include <nn/nlib/msgpack/JsonStreamParser.h>
#include <nn/nlib/msgpack/JsonStreamGenerator.h>
#include <nn/nlib/MemoryInputStream.h>
#include <nn/nlib/MemoryOutputStream.h>
#include <nn/nlib/Nlist.h>

namespace nn {
namespace msgpack{
    using NLIB_NS::msgpack::MpDirectWriter;
    using NLIB_NS::msgpack::MpObject;
    using NLIB_NS::msgpack::MpWalker;
    using NLIB_NS::msgpack::JsonStreamParser;
    using NLIB_NS::msgpack::JsonStreamGenerator;
    using NLIB_NS::msgpack::JsonStreamParserSettings;
    using NLIB_NS::InputStream;
    using NLIB_NS::MemoryInputStream;
    using NLIB_NS::OutputStream;
    using NLIB_NS::MemoryOutputStream;
    using NLIB_NS::Nlist;
    using NLIB_NS::UniquePtr;
    using NLIB_NS::ErrnoT;
    NLIB_ALWAYS_INLINE bool IsError(ErrnoT e)   NLIB_NOEXCEPT { return e != 0; }
    NLIB_ALWAYS_INLINE bool IsSuccess(ErrnoT e) NLIB_NOEXCEPT { return e == 0; }
}
}

