﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines for physical video interfaces.
 */

#pragma once

namespace nn { namespace edid {

    /**
     * @brief Physical video interfaces.
     */
    enum VideoInterface
    {
        VideoInterface_Analog,      //!< Analog video interface.
        VideoInterface_Digital,     //!< Undefined digital video interface.
        VideoInterface_Dvi,         //!< DVI is supported.
        VideoInterface_HdmiA,       //!< HDMI-a is supported.
        VideoInterface_HdmiB,       //!< HDMI-b is supported.
        VideoInterface_Mddi,        //!< MDDI is supported.
        VideoInterface_DisplayPort, //!< DisplayPort is supported.
    };

}}
