﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Supported sync type flags.
 */

#pragma once

#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace edid {

    /**
     * @brief Sync types supported by the display.
     */
    struct SyncType
    {
        typedef nn::util::BitFlagSet<5, SyncType>::Flag<0> SeparateSync;         //!< Separate sync for horizontal and vertical signals.
        typedef nn::util::BitFlagSet<5, SyncType>::Flag<1> CompositeSync;        //!< Composite sync on horizontal.
        typedef nn::util::BitFlagSet<5, SyncType>::Flag<2> BipolarCompositeSync; //!< Bipolar analog composite sync.
        typedef nn::util::BitFlagSet<5, SyncType>::Flag<3> SyncOnGreen;          //!< Composite sync on green video.
        typedef nn::util::BitFlagSet<5, SyncType>::Flag<4> SyncOnRgb;            //!< Composite sync on red, green, and blue video.
    };

    /**
     * @brief Set of sync types available on the display.
     */
    typedef nn::util::BitFlagSet<5, SyncType> SyncTypeSet;

}}
