﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Optional information about image size for display modes.
 */

#pragma once

#include <cstdint>

namespace nn { namespace edid {

    /**
     * @brief Extended size information for a particular display mode.
     */
    struct ImageSizeInfo
    {
        std::uint16_t imageWidth;       //!< Active image width in mm.
        std::uint16_t imageHeight;      //!< Active image height in mm.
        std::uint8_t  horizontalBorder; //!< Length (in pixels) to the addressable area from the left or right edge.
        std::uint8_t  verticalBorder;   //!< Length (in pixels) to the addressable area from the top or bottom edge.
    };

}}
