﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Error code definitions.
 */

#pragma once

namespace nn { namespace edid {

    /**
     * @brief Error codes to indicate success or failure.
     */
    enum Error
    {
        Error_None,        //!< The operation was successful.
        Error_InvalidSize, //!< The EDID's size is not standard.
        Error_Corrupt,     //!< The EDID appears to be corrupted.
    };

}}
