﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Common display mode information.
 */

#pragma once

#include <nn/edid/edid_StereoMode.h>

namespace nn { namespace edid {

    /**
     * @brief Provides information about a particular mode available on a display.
     */
    struct DisplayModeInfo
    {
        int width;              //!< Width in pixels.
        int height;             //!< Height in pixels.
        float refreshRate;      //!< Refresh rate in Hz.
        float imageAspectRatio; //!< The aspect ratio of the active area.
                                //!< For @a imageAspectRatio < 1.f, the image
                                //!< is landscape orientation.  Otherwise,
                                //!< it is portrait orientation.
        float pixelAspectRatio; //!< The pixel aspect ratio.
        StereoMode stereoMode;  //!< Stereoscopic 3D mode.
        bool isInterlaced;      //!< Whether the scan mode is interlaced.
    };

}}
