﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Common display information.
 */

#pragma once

#include <cstdint>
#include <nn/edid/edid_VideoInterface.h>
#include <nn/edid/edid_SyncLevel.h>
#include <nn/edid/edid_BlankLevel.h>
#include <nn/edid/edid_SyncType.h>
#include <nn/edid/edid_ColorDepth.h>
#include <nn/edid/edid_ColorType.h>
#include <nn/edid/edid_ContentType.h>

namespace nn { namespace edid {

    /**
     * @brief Common information about displays.
     */
    struct DisplayInfo
    {
        char manufacturerCode[4];         //!< Three character manufacturer ID.
        std::uint16_t productCode;        //!< Product code assigned by manufacturer.
        std::uint32_t serialNumber;       //!< Serial number assigned by manufacturer.
        std::uint16_t _date;              //!< Do not use directly.  Use GetDisplayWeekOfManufacture() and
                                          //!< GetDisplayYearOfManufacture().

        VideoInterface interfaceType;     //!< The physical interface used by the sink.
        SyncLevel sync;                   //!< The sync level used by the display.
        BlankLevel blankType;             //!< The blank level used by the display.

        ColorDepth depth;                 //!< Bit depth of colors on the display.
        ColorType colorSupport;           //!< The type of color used on the display.

        ContentTypeSet contentTypes;      //!< The set of content types supported on the display.
        SyncTypeSet syncTypes;            //!< Determines how the display will sync the signal.

        bool isSrgbDefaultColorSpace;     //!< Whether sRGB is the default color space.
        bool isContinuousFrequency;       //!< Whether the display supports continuous frequence mode.
        bool hasVsyncSerrations;          //!< Whether serrations are used on VSYNC.
        bool isStandbyModeSupported;      //!< Whether the display supports standby mode.
        bool isSuspendModeSupported;      //!< Whether the display supports suspend mode.
        bool isVeryLowPowerSupported;     //!< Whether the display supports a very low power mode.
        bool isYccQuantizationSelectable; //!< Whether YCC color space supports full and limited range.
        bool isRgbQuantizationSelectable; //!< Whether RGB color space supports full and limited range.
    };

}}
