﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace ZarfUploader
{
    class ZarfUploaderParam
    {
        private List<string> _targetZarfFiles = new List<string>();
        [CommandLineOption(
            "target",
            IsRequired = false,
            DefaultValue = null,
            Description = "アップロード対象の Zarf ファイルを指定します。\n")]
        public string TargetZarfFile
        {
            get
            {
                return null;
            }
            private set
            {
                _targetZarfFiles = value.Split(',').ToList();
            }
        }

        public IEnumerable<string> TargetZarfFiles
        {
            get
            {
                return _targetZarfFiles;
            }
        }

        private string _settingFile;
        [CommandLineOption(
            "setting",
            IsRequired = true,
            DefaultValue = null,
            Description = "設定情報を格納したファイルを指定します。\n")]
        public string SettingFile
        {
            get
            {
                return _settingFile;
            }
            private set
            {
                _settingFile = value;
            }
        }

        private string _coreReleaseZarf;
        [CommandLineOption(
            "core-release-zarf",
            IsRequired = false,
            DefaultValue = null,
            Description = "コアリリースに設定する Zarf ファイルを指定します。\n")]
        public string CoreReleaseZarf
        {
            get
            {
                return _coreReleaseZarf;
            }
            private set
            {
                _coreReleaseZarf = value;
            }
        }

        private string _coreRelease;
        [CommandLineOption(
            "core-release",
            IsRequired = false,
            DefaultValue = null,
            Description = "設定するコアリリース名を指定します。\n")]
        public string CoreRelease
        {
            get
            {
                return _coreRelease;
            }
            private set
            {
                _coreRelease = value;
            }
        }



        private bool _stockControlMode;
        [CommandLineOption(
            "stock-control",
            IsRequired = false,
            DefaultValue = false,
            Description = "スナップショットの数をコントロールします。\n")]
        public bool StockControlMode
        {
            get
            {
                return _stockControlMode;
            }
            private set
            {
                _stockControlMode = value;
            }
        }

        private string _snapshotRegex;
        [CommandLineOption(
            "snapshot-regex",
            IsRequired = false,
            DefaultValue = @"\+SS",
            Description = "スナップショットを示す正規表現を指定します。\n")]
        public string SnapshotRegex
        {
            get
            {
                return _snapshotRegex;
            }
            private set
            {
                _snapshotRegex = value;
            }
        }

        private int _maxSnapshotCount;
        [CommandLineOption(
            "max-snapshot-count",
            IsRequired = false,
            DefaultValue = 10,
            Description = "スナップショットをの最大保有数を示します。\n")]
        public int MaxSnapshotCount
        {
            get
            {
                return _maxSnapshotCount;
            }
            private set
            {
                _maxSnapshotCount = value;
            }
        }
    }
}
