﻿using Newtonsoft.Json;
using Nintendo.Zarf.v1;
using System;
using System.Collections.Generic;
using System.IO;
using System.IO.Compression;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using ZarfCreator.ZarfDefinitionData;

namespace ZarfCreator.MetaData
{
    internal class NdiRollback
    {
        private IEnumerable<string> archiveFiles { get; set; }
        private string installDir { get; set; }
        private JsonSerializerSettings serializerSettings { get; set; }
        private RollbackInfo rollbackInfo;

        /// <summary>
        /// NdiRollback クラスのインスタンスを作成します。
        /// </summary>
        /// <param name="archiveFiles">zip ファイルのリスト</param>
        /// <param name="installDirName">インストールディレクトリ名</param>
        /// <param name="serializerSettings"></param>
        /// <param name="rollbackInfo">ロールバック情報</param>
        public NdiRollback(IEnumerable<string> archiveFiles, string installDirName, JsonSerializerSettings serializerSettings, RollbackInfo rollbackInfo)
        {
            this.archiveFiles = archiveFiles;
            this.installDir = installDirName;
            this.serializerSettings = serializerSettings;
            this.rollbackInfo = rollbackInfo;
        }

        /// <summary>
        /// ndi-rollback.json を作成します。
        /// </summary>
        /// <param name="outputDirectory">出力先ディレクトリ</param>
        internal void Create(string outputDirectory)
        {
            try
            {
                var fileInventories =
                    this.rollbackInfo.EnumerateFileInventories(this.archiveFiles, this.installDir).ToArray();
                var content = CreateContent(fileInventories);
                File.WriteAllText(outputDirectory, content);
            }
            catch (Exception)
            {
                Console.Error.WriteLine("ERROR: Failed to create the rollback file.");
                throw;
            }
        }

        private string CreateContent(IEnumerable<FileInventoryInfo> fileInventories)
        {
            try
            {
                var rollback = new Zarf1NdiRollback();

                rollback.SigUnchanged =
                    new SortedSet<FileInventory>(
                        from fileTp in fileInventories
                        where fileTp.TrackType == FileTrackType.Track
                        select new FileInventory
                            {
                                Filename = fileTp.Path,
                                Signature = fileTp.Signature
                            }
                    );

                rollback.SigModified = new SortedSet<string>();

                rollback.FilesNotTracked =
                    new SortedSet<string>(
                        from fileTp in fileInventories
                        where fileTp.TrackType == FileTrackType.NotTrack
                        select fileTp.Path
                    );

                return JsonConvert.SerializeObject(rollback, this.serializerSettings);
            }
            catch (Exception)
            {
                Console.Error.WriteLine("ERROR:  Failed to create json contents.");
                throw;
            }
        }

    }
}
