﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Text.RegularExpressions;

namespace VsSolutionBuilderNinjaExecutor
{
    /// <summary>
    /// 異なるslnファイルが共通のプロジェクトファイルを使用した場合に
    /// 成果物の重複有無を判断するためのルール化済みのプロジェクトファイル情報
    /// </summary>
    public class RuledProjectInfo
    {
        /// <summary>
        /// ソリューションファイルのパス
        /// </summary>
        private string FilePath { get; set; }
        /// <summary>
        /// ビルドの種別
        /// </summary>
        private string Configuration { get; set; }
        /// <summary>
        /// プラットフォームの種別
        /// </summary>
        private string Platform { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="filePath">プロジェクトファイルのパス</param>
        /// <param name="configuration">ビルドの種別</param>
        /// <param name="platform">プラットフォームの種別</param>
        public RuledProjectInfo(string filePath, string configuration, string platform)
        {
            this.FilePath = filePath;
            this.Configuration = configuration;
            this.Platform = platform;
        }

        /// <summary>
        /// 重複判断をする。
        /// </summary>
        /// <param name="obj">比較対象のインスタンス</param>
        /// <returns>true：重複あり、false：重複なし</returns>
        public override bool Equals(object obj)
        {
            var argObj = (RuledProjectInfo)obj;
            if (
                (this.FilePath == argObj.FilePath) &&
                (this.Configuration == argObj.Configuration) &&
                (this.Platform == argObj.Platform))
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// インスタンスのHashコードを返却する。
        /// </summary>
        /// <returns>インスタンスのHashコード</returns>
        public override int GetHashCode()
        {
            return this.GetHashCode();
        }
    }
}
