﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunner
{
    using System;

    /// <summary>
    /// ユーティリティ関数を定義します。
    /// </summary>
    internal static class Utility
    {
        /// <summary>
        /// 指定されたパスから指定された拡張子を取り除きます。
        /// </summary>
        /// <param name="path">パス文字列です。</param>
        /// <param name="ext">拡張子です。</param>
        /// <returns>拡張子を取り除いたパスです。</returns>
        internal static string RemoveExtension(string path, string ext)
        {
            if (path == null || ext == null || !path.EndsWith(ext))
            {
                return path;
            }

            return path.Remove(path.Length - ext.Length);
        }
    }
}
