﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunner.Executer
{
    using System;

    /// <summary>
    /// テストコンテキストが中断された場合にスローされる例外。このクラスは継承できません。
    /// </summary>
    public sealed class TestContextException : Exception
    {
        /// <summary>
        /// 指定したエラーメッセージと、当該テストコンテキストを利用して、TestContextException クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="message">例外の原因を説明するエラーメッセージです。</param>
        /// <param name="testContext">当該テストコンテキストです。</param>
        public TestContextException(string message, TestContext testContext)
            : base(message)
        {
            this.TestContext = testContext;
        }

        /// <summary>
        /// 指定したエラーメッセージ、当該テストコンテキスト、例外の原因である内部例外への参照を利用して、TestContextException クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="message">例外の原因を説明するエラーメッセージです。</param>
        /// <param name="testContext">当該テストコンテキストです。</param>
        /// <param name="exception">例外の原因である内部例外への参照です。</param>
        public TestContextException(string message, TestContext testContext, Exception exception)
            : base(message, exception)
        {
            this.TestContext = testContext;
        }

        /// <summary>
        /// 当該テストコンテキストを取得します。
        /// </summary>
        public TestContext TestContext { get; private set; }
    }
}
