﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunner.Executer
{
    /// <summary>
    /// コンテキストの結果識別コードです。
    /// </summary>
    public enum ResultCode : uint
    {
        /// <summary>
        /// 成功です。
        /// </summary>
        PASS,

        /// <summary>
        /// テスト結果は失敗でした。
        /// </summary>
        FAIL,

        /// <summary>
        /// テストの実行がタイムアウトしました。
        /// </summary>
        TIME_OUT,

        /// <summary>
        /// テストの実行に失敗しました。
        /// </summary>
        ERROR,

        /// <summary>
        /// テストはスキップされました。
        /// </summary>
        SKIP,

        /// <summary>
        /// 不正なテストリストが指定されました。
        /// </summary>
        WRONG_YAML,

        /// <summary>
        /// サポート外のファイルがテスト対象として指定されました。
        /// </summary>
        WRONG_TYPE,

        /// <summary>
        /// 不正なファイルがテスト対象として指定されました。
        /// </summary>
        WRONG_FILE,

        /// <summary>
        /// Path タグが見つかりませんでした。
        /// </summary>
        NO_PATH,

        /// <summary>
        /// 指定されたテスト対象が見つかりませんでした。
        /// </summary>
        NO_FILE,

        /// <summary>
        /// 指定されたテスト対象の実行に必要なツールが見つかりませんでした。
        /// </summary>
        NO_TOOL,

        /// <summary>
        /// 指定されたテスト対象の実行に必要な開発機が見つかりませんでした。
        /// </summary>
        NO_TARGET,

        /// <summary>
        /// テスト対象が一意に定まりませんでした。
        /// </summary>
        NOT_UNIQUE,

        /// <summary>
        /// 入力されたデータの数が上限を超えました。
        /// </summary>
        OVER_LIMIT,

        /// <summary>
        /// テスト対象が指定されませんでした。
        /// </summary>
        NO_ENTRIES
    }
}
