﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SystemUpdaterNx.LaunchApplication
{
    using System;
    using Properties;
    using TargetShell.CommandPluginBase;
    using TargetShell.Library;
    using TargetShell.PluginInterface;

    /// <summary>
    /// プラグインの定数定義
    /// </summary>
    public class Constants
    {
        /// <summary>
        /// サブコマンド launch-application の文字列
        /// <summary>
        public const string SubCommand = "launch-application";
        /// <summary>
        /// オプション application の文字列
        /// <summary>
        public const string OptionApplication = "application";
    }

    /// <summary>
    /// サブコマンドのオプション引数
    /// </summary>
    public class SubCommandArgument : BaseCommand<CommandParameter>, ISubCommandArgument
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SubCommandArgument()
        {
            this.SubCommandName = Constants.SubCommand;
            // プラグイン実行後TargetManagerを終了させない
            this.KeepTargetManagerFlag = true;
        }

        /// <summary>
        /// コマンドラインパーサにコマンドを登録します。
        /// </summary>
        /// <param name="commandLineParser">コマンドラインパーサです。</param>
        public void RegisterWith(CommandLineParser commandLineParser)
        {
            var commandparameter = TargetShellLibrary.CastParameter<CommandParameter>(
                    this.OptionArgs.DevicePluginArgs);
            // サブコマンド
            var subcommand = commandLineParser.ActionCommand
                .AddCommand(Constants.SubCommand);
            subcommand
                .GetBuilder()
                .SetDescription(ControlApplicationResources.LaunchApplicationDescription);

            // 共通オプション
            this.OptionArgs.CommonArgs.RegisterWith(subcommand);

            // サブコマンド固有のオプション
            subcommand
                .AddValueOption(Constants.OptionApplication,
                    new Action<string>(x => commandparameter.Application = x))
                .GetBuilder()
                .SetDescription(ControlApplicationResources.LaunchApplicationDescriptionApplication)
                .Require();
        }
    }
}
