﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace PrivateNx.WriteBootConfig
{
    using System;
    using Properties;
    using TargetShell.CommandPluginBase;
    using TargetShell.Library;
    using TargetShell.PluginInterface;

    /// <summary>
    /// BootConfig書き換えで使用する定数
    /// </summary>
    public class Constants
    {
        /// <summary>
        /// サブコマンドの文字列
        /// <summary>
        public const string SubCommand = "write-boot-config";
        /// <summary>
        /// オプション all-boot-config の文字列
        /// <summary>
        public const string OptionAllBootConfig = "all-boot-config";
        /// <summary>
        /// オプション connection-path の文字列
        /// <summary>
        public const string OptionConnectionPath = "connection-path";
        /// <summary>
        /// オプション hw-type の文字列
        /// <summary>
        public const string OptionHardwareType = "hw-type";
        /// <summary>
        /// オプション key-type の文字列
        /// <summary>
        public const string OptionKeyType = "key-type";
        /// <summary>
        /// オプション signed-type の文字列
        /// <summary>
        public const string OptionSignedType = "signed-type";
    }

    /// <summary>
    /// サブコマンドのオプション引数
    /// </summary>
    public class SubCommandArgument : BaseCommand<CommandParameter>, ISubCommandArgument
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SubCommandArgument()
        {
            this.SubCommandName = Constants.SubCommand;
        }

        /// <summary>
        /// コマンドラインパーサにコマンドを登録します。
        /// </summary>
        /// <param name="commandLineParser">コマンドラインパーサです。</param>
        public void RegisterWith(CommandLineParser commandLineParser)
        {
            // サブコマンド
            var subcommand = commandLineParser.ActionCommand
                .AddCommand(Constants.SubCommand);
            subcommand
                .GetBuilder()
                .SetDescription(WriteBootConfigResources.Description);

            // 共通オプション
            this.OptionArgs.CommonArgs.Setting.DescriptionHwType =
                    WriteBootConfigResources.DescriptionHardwareType;
            this.OptionArgs.CommonArgs.Setting.DescriptionConnectionPath =
                    WriteBootConfigResources.DescriptionConnectionPath;
            this.OptionArgs.CommonArgs.RegisterWith(subcommand);

            // サブコマンド固有のオプション
            subcommand
                .AddValueOption(Constants.OptionKeyType,
                    new Action<string>(x => this.DevicePluginArgs.KeyType = x))
                .GetBuilder()
                .SetDescription(WriteBootConfigResources.DescriptionKeyType);
            subcommand
                .AddValueOption(Constants.OptionSignedType,
                    new Action<string>(x => this.DevicePluginArgs.SignedType = x))
                .GetBuilder()
                .SetDescription(WriteBootConfigResources.DescriptionSignedType);
            subcommand
                .AddFlagOption(Constants.OptionAllBootConfig,
                    new Action(() => this.DevicePluginArgs.AllBootConfig = true))
                .GetBuilder()
                .SetDescription(WriteBootConfigResources.DescriptionAllBootConfig);
        }
    }
}
