﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace PrivateNx.InitializeBuildImage
{
    /// <summary>
    /// 初期化イメージ(initimg)を使ってEDEV初期化の定数
    /// </summary>
    public static class ConstantsEdev
    {
        /// <summary>
        /// キャレット文字。値に入れ替えに使用する
        /// </summary>
        public const string Caret = "^";

        /// <summary>
        /// コマンドで使用する文字列定義一覧
        /// </summary>
        public static class CommandString
        {
            /// <summary>
            /// キータイプ１の文字列
            /// </summary>
            public const string KeyTypeK1 = @"K1";
            /// <summary>
            /// キータイプ２の文字列
            /// </summary>
            public const string KeyTypeK2 = @"K2";
            /// <summary>
            /// キータイプ３の文字列
            /// </summary>
            public const string KeyTypeK3 = @"K3";
            /// <summary>
            /// キータイプ５の文字列
            /// </summary>
            public const string KeyTypeK5 = @"K5";
            /// <summary>
            /// NXFP2-a64プラットフォームネーム文字列
            /// </summary>
            public const string Nxfp2a64 = @"NXFP2-a64";
            /// <summary>
            /// NXFP2-a64プラットフォームネームに対応するパス名
            /// </summary>
            public const string Nxfp2a64Path = @"NX-NXFP2-a64";
            /// <summary>
            /// NXFP2-a32プラットフォームネーム文字列
            /// </summary>
            public const string Nxfp2a32 = @"NXFP2-a32";
            /// <summary>
            /// NXFP2-a32プラットフォームネームに対応するパス名
            /// </summary>
            public const string Nxfp2a32Path = @"NX-NXFP2-a32";
            /// <summary>
            /// jetson-tk2プラットフォームネーム
            /// </summary>
            public const string JetsonTk2 = @"jetson-tk2";
            /// <summary>
            /// jetson-tk2-a64プラットフォーム
            /// </summary>
            public const string JetsonTk2A64 = @"jetson-tk2-a64";
            /// <summary>
            /// 署名済みカーネルの文字列
            /// </summary>
            public const string SignedString = @"Signed";
            /// <summary>
            /// 非署名カーネルの文字列
            /// </summary>
            public const string UnsignedString = @"Unsigned";
            /// <summary>
            /// CopperDevice判定文字列
            /// </summary>
            public const string CopperDevice = @"XG";
            /// <summary>
            /// HostBridge文字列
            /// </summary>
            public const string HostBridge = "HostBridge";
            /// <summary>
            /// HostBridge文字列（ディレクトリ名に使用している）
            /// </summary>
            public const string Hb = "Hb";
            /// <summary>
            /// Usb文字列
            /// </summary>
            public const string Usb = "Usb";
            /// <summary>
            /// キータイプ文字列
            /// </summary>
            public const string K5 = "K5";
        }

        public class ConvertHardwareConfigToKeyTypeClass
        {
            public string[,] ConvertHardwareConfigToKeyTypeTable
            {
                get { return this.convertHardwareConfigToKeyTypeTable; }
            }
            /// <summary>
            /// HardwareConfigからKeyTypeに変更するコンバートテーブル
            /// </summary>
            private string[,] convertHardwareConfigToKeyTypeTable =
            {
                {
                    "SDEV_00_01_08", "K2"
                },
                {
                    "SDEV_00_01_09_01", "K3"
                },
                {
                    "SDEV_00_01_09_02", "K3"
                },
                {
                    "SDEV_00_02_00_00", "K5"
                },
                {
                    "EDEV_00_02_00_01", "K2"
                },
                {
                    "EDEV_00_02_00_02", "K3"
                },
                {
                    "EDEV_00_03_00_00", "K5"
                },
            };
        }

        /// <summary>
        /// ControlTargetPrivate.exe へのパス
        /// </summary>
        public const string ControlTargetPrivatePath = @"Tools\CommandLineTools\" +
                @"ControlTargetPrivate.exe";

        /// <summary>
        /// RcmWriter.exe へのパス
        /// </summary>
        public const string RcmWriter = @"Externals\NxSystemImages\" +
                @"RcmWriter\RcmWriter.exe";

        /// <summary>
        /// RcmWriter.[KEYTYPE].rcm へのパス
        /// </summary>
        public const string RcmWriterRcm = @"Externals\NxSystemImages\RcmWriter\RcmWriter." +
                Caret + @".rcm";

        /// <summary>
        /// RecoverySystem-Generic.xml へのパス
        /// </summary>
        public const string RcmWriterXmlWoBc = @"Integrate\Sources\Configs\RcmWriter\" +
                @"RecoverySystem-Generic.xml";

        /// <summary>
        /// RecoverySystem-Generic-WithBootConfig.xml へのパス
        /// </summary>
        public const string RcmWriterXmlWithBc = @"Integrate\Sources\Configs\RcmWriter\" +
                @"RecoverySystem-Generic-WithBootConfig.xml";

        /// <summary>
        /// RecoverySystem-Generic.xml へのパス
        /// </summary>
        public const string RcmWriterXmlWoBcM2 = @"Integrate\Sources\Configs\RcmWriter\" +
                @"RecoverySystem-Generic-M2.xml";

        /// <summary>
        /// RecoverySystem-Generic-WithBootConfig.xml へのパス
        /// </summary>
        public const string RcmWriterXmlWithBcM2 = @"Integrate\Sources\Configs\RcmWriter\" +
                @"RecoverySystem-Generic-WithBootConfig-M2.xml";

        /// <summary>
        /// bc[BOOTCONFIG].bin へのパス
        /// </summary>
        public const string BootConfigInRepo = @"Externals\NxBootConfigs\bc-" + Caret + @".bin";

        /// <summary>
        /// bc-dummy.bin へのパス
        /// </summary>
        public const string BootConfigDummy = @"Externals\NxBootConfigs\bc-dummy.bin";

        /// <summary>
        /// Recovery-[KEYCONFIG].bct へのパス
        /// </summary>
        public const string Bct = @"Externals\NxSystemImages\BootLoader\Recovery-" +
                Caret + @".bct";

        /// <summary>
        /// Recovery-[KEYCONFIG].bl へのパス
        /// </summary>
        public const string Bl = @"Externals\NxSystemImages\BootLoader\Recovery-" + Caret + @".bl";

        /// <summary>
        /// gpt-recovery.img へのパス
        /// </summary>
        public const string Gpt = @"Externals\NxSystemImages\Recovery\gpt-recovery.img";

        /// <summary>
        /// DefaultPackage2ForInitialize.package2.img へのパス
        /// </summary>
        public const string Package2Unsigned = @"Programs\Eris\Outputs\" + Caret +
                @"\SystemImages\Package2Images\DefaultPackage2ForInitialize\" + Caret +
                @"\DefaultPackage2ForInitialize.package2.img";

        /// <summary>
        /// p2initialize.bin へのパス
        /// </summary>
        public const string Package2Signed = @"Externals\NxSystemImages\Package2Signed\" + Caret +
                @"\p2initialize.bin";

        /// <summary>
        /// RecoverySystemPartitionWithUsb-P2Unsigned.fatimg へのパス
        /// </summary>
        public const string SystemPartitionP2Unsigned = @"Programs\Eris\Outputs\" + Caret +
                @"\SystemImages\SystemPartition\RecoverySystemPartitionWithUsb-P2Unsigned\" +
                Caret + @"\RecoverySystemPartitionWithUsb-P2Unsigned.fatimg";

        /// <summary>
        /// RecoverySystemPartitionWithUsb-P2Signed.fatimg へのパス
        /// </summary>
        public const string SystemPartitionP2Signed = @"Programs\Eris\Outputs\" + Caret +
                @"\SystemImages\SystemPartition\RecoverySystemPartitionWithUsb-P2Signed\" +
                Caret + @"\RecoverySystemPartitionWithUsb-P2Signed.fatimg";

        /// <summary>
        /// 初期化イメージファイル名
        /// </summary>
        public const string InitialImageName = "NX-" + Caret + "-" + Caret + "-" + Caret + "-" +
                Caret + "-" + Caret + "-" + Caret;

        /// <summary>
        /// 初期化イメージファイルへのパス
        /// </summary>
        public const string InitialImagePath = @"Programs\Eris\Outputs\" + Caret +
                @"\InitialImages\" + Caret + @"\" + Caret + @"\" + Caret + @".initimg";

        /// <summary>
        /// SystemUpdaterHostFs.nsp へのパス
        /// </summary>
        public const string SystemUpdater = @"Programs\Chris\Outputs\" + Caret + @"\TargetTools\" +
                @"SystemUpdaterHostFs\" + Caret + @"\SystemUpdaterHostFs.nsp";

        /// <summary>
        /// RcmWriter関係の出力先パス
        /// </summary>
        public const string OutputDir = @"Integrate\Outputs\RcmWriter";

        /// <summary>
        /// RecoverySystem-Generic.xml へのパス
        /// </summary>
        public const string OutputConfig = OutputDir + @"\RecoverySystem-Generic.xml";

        /// <summary>
        /// Bct.img へのパス
        /// </summary>
        public const string OutputBct = OutputDir + @"\Bct.img";

        /// <summary>
        /// Bl.img へのパス
        /// </summary>
        public const string OutputBl = OutputDir + @"\Bl.img";

        /// <summary>
        /// BootConfig.img へのパス
        /// </summary>
        public const string OutputBootConfig = OutputDir + @"\BootConfig.img";

        /// <summary>
        /// Gpt.img へのパス
        /// </summary>
        public const string OutputGpt = OutputDir + @"\Gpt.img";

        /// <summary>
        /// Package2.img へのパス
        /// </summary>
        public const string OutputPackage2 = OutputDir + @"\Package2.img";

        /// <summary>
        /// SystemPartition.fatimg へのパス
        /// </summary>
        public const string OutputSystemPartition = OutputDir + @"\SystemPartition.fatimg";

        /// <summary>
        /// デバイスの起動待ちの最大回数
        /// </summary>
        public const int MaxWaitStartUpDevice = 30;
    }
}
