﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace PrivateNx.InitializeBuildImage
{
    using System;
    using Properties;
    using TargetShell.CommandPluginBase;
    using TargetShell.Library;
    using TargetShell.PluginInterface;

    /// <summary>
    /// 初期化イメージ(initimg)で初期化の定数定義
    /// </summary>
    public class Constants
    {
        /// <summary>
        /// サブコマンドの文字列
        /// <summary>
        public const string SubCommand = "initialize-build-image";
        /// <summary>
        /// オプション boot-type の文字列
        /// <summary>
        public const string OptionBootType = "boot-type";
        /// <summary>
        /// オプション build-type の文字列
        /// <summary>
        public const string OptionBuildType = "build-type";
        /// <summary>
        /// オプション connection-type の文字列
        /// <summary>
        public const string OptionConnectionType = "connection-type";
        /// <summary>
        /// オプション developer-type の文字列
        /// <summary>
        public const string OptionDeveloperType = "developer-type";
        /// <summary>
        /// オプション key-type の文字列
        /// <summary>
        public const string OptionKeyType = "key-type";
        /// <summary>
        /// オプション phidgets-off の文字列
        /// <summary>
        public const string OptionPhidgetsOff = "phidgets-off";
        /// <summary>
        /// オプション platform-name の文字列
        /// <summary>
        public const string OptionPlatformName = "platform-name";
        /// <summary>
        /// オプション signed-type の文字列
        /// <summary>
        public const string OptionSignedType = "signed-type";
        /// <summary>
        /// オプション skip-helloworld の文字列
        /// <summary>
        public const string OptionSkipHelloWorld = "skip-helloworld";
    }

    /// <summary>
    /// サブコマンドのオプション引数
    /// </summary>
    public class SubCommandArgument : BaseCommand<CommandParameter>, ISubCommandArgument
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SubCommandArgument()
        {
            this.SubCommandName = Constants.SubCommand;
        }

        /// <summary>
        /// コマンドラインパーサにコマンドを登録します。
        /// </summary>
        /// <param name="commandLineParser">コマンドラインパーサです。</param>
        public void RegisterWith(CommandLineParser commandLineParser)
        {
            // サブコマンド
            var subcommand = commandLineParser.ActionCommand
                .AddCommand(Constants.SubCommand);
            subcommand
                .GetBuilder()
                .SetDescription(InitializeBuildImageResources.Description);

            // 共通オプション
            this.OptionArgs.CommonArgs.RegisterWith(subcommand);

            // サブコマンド固有のオプション
            subcommand
                .AddValueOption(Constants.OptionPlatformName,
                    new Action<string>(
                    x => this.DevicePluginArgs.BuildImageParam.PlatformName = x))
                .GetBuilder()
                .SetDescription(InitializeBuildImageResources.DescriptionPlatformName);
            subcommand
                .AddValueOption(Constants.OptionBuildType,
                    new Action<string>(
                    x => this.DevicePluginArgs.BuildImageParam.BuildType = x))
                .GetBuilder()
                .SetDescription(InitializeBuildImageResources.DescriptionBuildType);
            subcommand
                .AddValueOption(Constants.OptionKeyType,
                    new Action<string>(
                    x => this.DevicePluginArgs.BuildImageParam.KeyType = x))
                .GetBuilder()
                .SetDescription(InitializeBuildImageResources.DescriptionKeyType);
            subcommand
                .AddValueOption(Constants.OptionBootType,
                    new Action<string>(
                    x => this.DevicePluginArgs.BuildImageParam.BootType = x))
                .GetBuilder()
                .SetDescription(InitializeBuildImageResources.DescriptionBootType);
            subcommand
                .AddValueOption(Constants.OptionConnectionType,
                    new Action<string>(
                    x => this.DevicePluginArgs.BuildImageParam.ConnectionType = x))
                .GetBuilder()
                .SetDescription(InitializeBuildImageResources.DescriptionConnectionType);
            subcommand
                .AddValueOption(Constants.OptionSignedType,
                    new Action<string>(
                    x => this.DevicePluginArgs.BuildImageParam.SignedType = x))
                .GetBuilder()
                .SetDescription(InitializeBuildImageResources.DescriptionSignedType);
            subcommand
                .AddValueOption(Constants.OptionDeveloperType,
                    new Action<string>(
                    x => this.DevicePluginArgs.BuildImageParam.DeveloperType = x))
                .GetBuilder()
                .SetDescription(InitializeBuildImageResources.DescriptionDeveloperType);
            subcommand
                .AddFlagOption(Constants.OptionPhidgetsOff,
                    new Action(
                    () => this.DevicePluginArgs.BuildImageParam.PhidgetsOff = true))
                .GetBuilder()
                .SetDescription(InitializeBuildImageResources.DescriptionPhidgetsOff);
            subcommand
                .AddFlagOption(Constants.OptionSkipHelloWorld,
                    new Action(
                    () => this.DevicePluginArgs.BuildImageParam.PhidgetsOff = true))
                .GetBuilder()
                .SetDescription(InitializeBuildImageResources.DescriptionSkipHelloWorld);
        }
    }
}
