﻿namespace PackageCreator
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// YAML のノードを変換するクラス
    /// </summary>
    public static class YamlConverter
    {
        #region ノードのコンバータ
        /// <summary>
        /// 内容が YamlScalarNode である YamlSequencialNode の情報を List&lt;string&gt; に変換します。
        /// </summary>
        /// <param name="target">変換する List&lt;object&gt;</param>
        /// <returns>変換された List&lt;string&gt;</returns>
        public static List<string> ConvertFromSequencialNode(this List<object> target)
        {
            return target.ConvertAll(item => (string)item);
        }

        /// <summary>
        /// 内容が YamlMappingNode である YamlSequencialNode の情報を List&lt;Dictionary&lt;string, string&gt;&gt; に変換します。
        /// </summary>
        /// <param name="target">変換する List&lt;object&gt; </param>
        /// <returns>変換された  List&lt;Dictionary&lt;string, string&gt;&gt; </returns>
        public static List<Dictionary<string, string>> ConvertFromSequencialMappingNode(this List<object> target)
        {
            return target.ConvertAll(item => (item as Dictionary<string, object>).ConvertToStringStringDictionary());
        }
        private static Dictionary<string, string> ConvertToStringStringDictionary(this Dictionary<string, object> target)
        {
            return target.ToDictionary(pair => pair.Key, pair => (string)pair.Value);
        }
        #endregion
    }
}
