﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

namespace NxAgingHelper
{
    public class EventLogger
    {
        private StreamWriter m_Writer;

        public void Open(string path)
        {
            try
            {
                // ログファイルのディレクトリが存在しない場合には、自動で作成する
                string dir = Path.GetDirectoryName(path);
                if (dir != string.Empty && !Directory.Exists(dir))
                {
                    Directory.CreateDirectory(dir);
                }

                m_Writer = new StreamWriter(path, true);
            }
            catch (Exception e)
            {
                throw new Exception(string.Format("Failed to open Event log file ({0}).", path), e);
            }
        }

        public void Close()
        {
            m_Writer.Close();
        }

        public void Write(string[] data)
        {
            // 複数の Executor が同時に呼ぶので、スレッドセーフにする
            lock (this)
            {
                var builder = new StringBuilder();

                builder.Append(DateTime.Now.ToString("[yyyy-MM-dd HH:mm:ss.fff]"));
                builder.Append(" ");
                builder.Append(string.Join(" ", data));

                m_Writer.WriteLine(builder.ToString());
                m_Writer.Flush();
            }
        }
    }
}
