﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.IO.Ports;

namespace NxAgingHelper
{
    public class HdmiController
    {
        private PrimS.Telnet.Client m_Client;
        private string m_HostName;
        private SerialPort m_Port;

        public void Open(string targetname)
        {
            m_HostName = null;
            m_Port = null;

            try
            {
                if (targetname.StartsWith("COM"))
                {
                    m_Port = new SerialPort(targetname, 19200, Parity.None, 8, StopBits.One);
                    m_Port.Open();
                }
                else
                {
                    m_HostName = targetname;
                    m_Client = new PrimS.Telnet.Client(targetname, 23, new System.Threading.CancellationToken());
                }
            }
            catch (Exception e)
            {
                throw new Exception(string.Format("Failed to connect to HDMI Switcher ({0}).", targetname), e);
            }
        }

        public void Close()
        {
            if (m_Port != null)
            {
                m_Port.Close();
            }
        }

        public void Switch(int port)
        {
            if (m_Port != null)
            {
                m_Port.Write(string.Format("port {0}\r", port));
            }
            else
            {
                m_Client.Write(string.Format("s {0}\r\n", port)).Wait();
                m_Client.ReadAsync();
            }
        }
    }
}
