﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Text;

namespace NxAgingHelper
{
    internal class StringCircularBuffer
    {
        private const int MaxQueueCount = 256;
        private Queue<string> m_Queue = new Queue<string>(MaxQueueCount);

        public void Append(string text)
        {
            lock (m_Queue)
            {
                m_Queue.Enqueue(text);
                while (m_Queue.Count > MaxQueueCount)
                {
                    m_Queue.Dequeue();
                }
            }
        }

        public string Get()
        {
            var builder = new StringBuilder();

            lock (m_Queue)
            {
                foreach (var text in m_Queue)
                {
                    builder.Append(text);
                }
            }

            return builder.ToString();
        }
    }
}
