﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.Base
{
    /// <summary>
    /// SDK のルートパスの設定: 設定方法の種類 SdkRootKind + その値
    /// </summary>
    public struct SdkRoot : IEquatable<SdkRoot>
    {
        public static readonly SdkRoot Empty = new SdkRoot(SdkRootKind.DirectProperty, string.Empty);

        public SdkRootKind Kind { get; }
        public string Value { get; }
        public bool IsEmpty => string.IsNullOrEmpty(Value);

        public SdkRoot(SdkRootKind kind, string value)
        {
            this.Kind = kind;
            this.Value = value;
        }

        public SdkRoot(SdkRoot other)
        {
            this.Kind = other.Kind;
            this.Value = other.Value;
        }

        public string ToUnevaluatedPath()
        {
            switch (this.Kind)
            {
                case SdkRootKind.DirectProperty:
                    return this.Value;
                case SdkRootKind.NdiEnvironmentName:
                    throw new NotImplementedException();
                default:
                    throw new ArgumentException();
            }
        }

        public string ToEvaluatedPath() =>
            MsBuildUtil.EvaluateConfigurationProperty(ToUnevaluatedPath());

        public bool Equals(SdkRoot other)
        {
            return this == other;
        }

        // override object.Equals
        public override bool Equals(object obj)
        {
            if (obj == null || GetType() != obj.GetType())
            {
                return false;
            }

            var other = (SdkRoot)obj;
            return this == other;
        }

        // override object.GetHashCode
        public override int GetHashCode()
        {
            return this.Value.GetHashCode() + (int)this.Kind;
        }

        public static bool operator ==(SdkRoot lhs, SdkRoot rhs)
        {
            return lhs.Kind == rhs.Kind && lhs.Value == rhs.Value;
        }

        public static bool operator !=(SdkRoot lhs, SdkRoot rhs)
        {
            return !(lhs == rhs);
        }
    }
}
