﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.Base
{
    [Serializable]
    public class InvalidSdkRootException : Exception
    {
        public InvalidSdkRootException() { }
        public InvalidSdkRootException(string rootPath) : base(MakeMessage(rootPath)) { }
        public InvalidSdkRootException(string rootPath, Exception inner) : base(MakeMessage(rootPath), inner) { }
        protected InvalidSdkRootException(
          System.Runtime.Serialization.SerializationInfo info,
          System.Runtime.Serialization.StreamingContext context) : base(info, context)
        { }
        private static string MakeMessage(string rootPath)
        {
            return ErrorMessageUtil.InvalidSdkRoot(rootPath);
        }
    }
}
