﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.Base
{
    /// <summary>
    /// 1 つのプロジェクト構成 （Configuration|Platform）です。
    /// </summary>
    public struct ConfigurationPair : IEquatable<ConfigurationPair>
    {
        public string Configuration { get; }
        public string Platform { get; }

        public ConfigurationPair(string configuration, string platform)
        {
            this.Configuration = configuration;
            this.Platform = platform;
        }

        public ConfigurationPair(string pairString) : this()
        {
            var elements = pairString.Split('|');
            if (elements.Length != 2)
            {
                throw new ArgumentException("must have the form of '<Configuration>|<Platform>'", nameof(pairString));
            }
            this.Configuration = elements[0];
            this.Platform = elements[1];
        }

        public bool Equals(ConfigurationPair other)
        {
            return Configuration == other.Configuration && Platform == other.Platform;
        }

        public override bool Equals(object obj)
        {
            if (obj == null || GetType() != obj.GetType())
            {
                return false;
            }

            return Equals((ConfigurationPair)obj);
        }

        public static bool operator ==(ConfigurationPair lhs, ConfigurationPair rhs)
        {
            return lhs.Equals(rhs);
        }

        public static bool operator !=(ConfigurationPair lhs, ConfigurationPair rhs)
        {
            return !lhs.Equals(rhs);
        }

        public override int GetHashCode()
        {
            return new Tuple<string, string>(Configuration, Platform).GetHashCode();
        }

        public override string ToString()
        {
            return string.Format("{0}|{1}", Configuration, Platform);
        }
    }
}
