﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Text;

namespace MSBuildWrapper.ServiceMessage
{
    public static class TeamCityMessage
    {
        public static string EnterMessage(string suiteName, string testName)
        {
            var message = new List<string>();

            var suiteStartArg = new Dictionary<string, string>()
            {
                ["name"] = suiteName
            };
            message.Add(CreateTeamCityMessage("testSuiteStarted", suiteStartArg));

            var testStartArg = new Dictionary<string, string>()
            {
                ["name"] = testName,
                ["captureStandardOutput"] = "true"
            };
            message.Add(CreateTeamCityMessage("testStarted", testStartArg));

            return string.Join("\n", message);
        }

        public static string ExitMessage(string suiteName, string testName, string error = null)
        {
            var message = new List<string>();

            if (error != null)
            {
                var errorArg = new Dictionary<string, string>()
                {
                    ["name"] = testName,
                    ["message"] = error
                };
                message.Add(CreateTeamCityMessage("testFailed", errorArg));
            }

            var testFinishArg = new Dictionary<string, string>()
            {
                ["name"] = testName
            };
            message.Add(CreateTeamCityMessage("testFinished", testFinishArg));

            var suiteFinishArg = new Dictionary<string, string>()
            {
                ["name"] = suiteName
            };
            message.Add(CreateTeamCityMessage("testSuiteFinished", suiteFinishArg));

            return string.Join("\n", message);
        }

        private static string CreateTeamCityMessage(string messageName, Dictionary<string, string> argument)
        {
            var argumentList = new List<string>();
            foreach (var arg in argument)
            {
                argumentList.Add($"{arg.Key}='{ConvertToServiceMessage(arg.Value)}'");
            }

            return CreateTeamCityMessage(messageName, string.Join(" ", argumentList));
        }

        private static string CreateTeamCityMessage(string messageName, string argument)
        {
            return string.Format($"##teamcity[{messageName} {argument}]");
        }

        private static string ConvertToServiceMessage(string message)
        {
            var builder = new StringBuilder(message);

            // TeamCity 向けログ内の特殊記号はエスケープする
            builder.Replace("|", "||");
            builder.Replace("'", "|'");
            builder.Replace("\n", "|n");
            builder.Replace("\r", "|r");
            builder.Replace("[", "|[");
            builder.Replace("]", "|]");

            return builder.ToString();
        }
    }
}
