﻿using System.Xml;

namespace IFFRefGen.Src
{
    // ComplexType 内容の抽象クラス
    public abstract class XsdContent
    {
        // コンストラクタ
        public XsdContent(XmlElement element, XsdComplexType containerType)
        {
            this.Element = element;
            this.ContainerType = containerType;
        }

        // 初期化
        public virtual void Initialize() { }

        // 使用フラグを立てる
        public virtual void Use() { }

        // 要素
        public XmlElement Element { get; private set; }
        // コンテンツのコンテナ
        public XsdComplexType ContainerType { get; private set; }
    }
}
