﻿using System.Xml;
using System;
using System.Text;
using System.Diagnostics;
using System.IO;

namespace IFFRefGen.Src
{
    // HTML サンプル
    public class HtmlSample
    {
        // テンプレートファイルの名前
        private readonly string TemplateFileName = "TmplSample.html";
        // 保存パスのフォーマット文字列
        private readonly string SavePathFormat = "html/sample/{0}.html";

        // ヘッダのタイトル XPath
        private readonly string HeadTitleXPath = "/html/head/title";
        // 本文のタイトル XPath
        private readonly string BodyTitleXPath = "/html/body/h1[@id=\"title\"]";
        // タイトルのフォーマット
        private readonly string TitleFormat = "{0}";

        // サンプルリンクの XPath
        private readonly string SampleLinkXPath = "//a[@id='sample_link']";
        // サンプルリンクのフォーマット
        private readonly string SampleLinkFormat = "data/{0}";

        // サンプルの XPath
        private readonly string SampleXPath = "//pre[@class='code']";

        // コンストラクタ
        public HtmlSample(SmplData sample)
        {
            this.Sample = sample;
            this.Template = new XmlDocument();
        }

        // 初期化
        public void Initialize()
        {
            // テンプレートの読み込み
            string loadPath = GApp.Config.HtmlOutputConfig.TemplateElementFolder + this.TemplateFileName;
            this.Template.Load(loadPath);
        }

        // 生成
        public void Generate()
        {
            // タイトルの生成
            GenerateTitle();

            // サンプルリンクの生成
            GenerateSampleLink();

            // サンプルの生成
            GenerateSample();

            // 保存
            string savePath = System.IO.Path.Combine(GApp.Config.HtmlOutputConfig.OutputFolder, string.Format(this.SavePathFormat,
                this.Sample.FileName));
            GHtml.Save(this.Template, savePath);
        }

        // タイトルの生成
        private void GenerateTitle()
        {
            string title = string.Format(TitleFormat, this.Sample.FileName);
            XmlNode headTitle = this.Template.SelectSingleNode(this.HeadTitleXPath);
            headTitle.InnerText = title;

            XmlNode bodyTitle = this.Template.SelectSingleNode(this.BodyTitleXPath);
            bodyTitle.InnerText = title;
        }

        // サンプルリンクの生成
        private void GenerateSampleLink()
        {
            XmlNode sampleLinkNode = this.Template.SelectSingleNode(this.SampleLinkXPath);
            XmlAttribute href = this.Template.CreateAttribute("href");
            href.InnerText = string.Format(SampleLinkFormat, this.Sample.FileName);
            sampleLinkNode.Attributes.Append(href);
        }

        // サンプルの生成
        private void GenerateSample()
        {
            XmlNode sampleNode = this.Template.SelectSingleNode(this.SampleXPath);
            sampleNode.InnerText = this.Sample.GetLines();
        }

        // サンプル
        public SmplData Sample { get; private set; }
        // テンプレート
        public XmlDocument Template { get; private set; }
    }
}
