# coding: UTF-8

# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.

import argparse
import codecs
import locale
import os
import re
import sys

import shlex
import subprocess

APP_ROOT   = os.path.dirname( os.path.abspath(__file__) )
SIGLO_ROOT = os.path.normpath( APP_ROOT + '/../../../..' )

def normalize_path(path):
    """パスを正規化します。

    Args:
        path:               正規化対象のパスです。
    Returns:
        区切り文字に / を使用する絶対パスです。
    """
    return os.path.abspath(path).replace('\\', '/')

def bundle_to_api_list(bundle_file_list_uniq, sdk_version, is_generate_test_file):
    normalized_siglo_root_path = normalize_path(SIGLO_ROOT)
    filehandle = open("api-list.xml", "w")
    filehandle.write("<api-list>" + "\n")

    private_api_list = open("private_api.list", "w")

    for bundle_file in bundle_file_list_uniq:
        # NX64 向けと NX32 向けで共通しているシンボルは重複として削除するため、一旦リストに保持する。
        symbol_name_list_uniq = []

        bundleFile = open(bundle_file, "r")
        lines = bundleFile.readlines()
        bundleFile.close()

        # 引数はバンドルファイルの yml ファイルであり、これを id に変換する
        relative_bundle_file_path = bundle_file.replace(normalize_path(SIGLO_ROOT) + "/", '').rstrip("\n")
        relative_bundle_file_path = relative_bundle_file_path.replace("Integrate/Packages/", '').replace('/', '_')
        bundle_file_name = relative_bundle_file_path.replace(".bundle.yml", "")
        bundle_id_name = bundle_file_name.replace('.', '_')

        for line in lines:
            if re.search("\.h$", line) != None:
                # Result.XXX.h で終わるファイルは、他の Result ヘッダからインクルードされる前提のものなので、検出外とする
                if re.search(r"Result\.\S+\.h$", line) != None:
                    print "skip " + line
                # sf の自動生成ファイルは対象外に (clang がクラッシュする)
                elif re.search(r"\.sfdl\.h$", line) != None:
                    print "skip " + line
                # clang がクラッシュするファイルを対象外に
                elif re.search(r"Programs/Chris/Include/nn/sf/cmif/client/sf_CmifProxyFactory\.h$", line) != None:
                    print "skip " + line
                # curl 用の対策
                elif re.search(r"Programs/Eris/Outputs/Include/curl/curlrules\.h$", line) != None:
                    print "skip " + line
                elif re.search(r"Programs/Eris/Outputs/Include/curl/easy\.h$", line) != None:
                    print "skip " + line
                # 直接インクルードすることが想定されていないヘッダ
                elif re.search(r"Programs/Iris/Include/nn/hid/detail/hid_KeyboardKeyDeclaration\.h$", line) != None:
                    print "skip " + line
                elif re.search(r"Programs/Chris/Include/nn/os/detail/os_ThreadTypes-os\.win32\.private\.h$", line) != None:
                    print "skip " + line
                # デバッグAPIリストに登録されているヘッダのシンボルは重複して表示したくないので、除外する
                elif re.search(r"Programs/Chris/Include/nn/fs/fs_Host\.h$", line) != None:
                    print "skip " + line
                elif re.search(r"Programs/Chris/Include/nn/fs/fs_RomForDebug\.h$", line) != None:
                    print "skip " + line
                elif re.search(r"Programs/Chris/Include/nn/fs/fs_SdCardForDebug\.h$", line) != None:
                    print "skip " + line
                elif re.search(r"Programs/Chris/Include/nn/fs/fs_SaveDataForDebug\.h$", line) != None:
                    print "skip " + line
                elif re.search(r"Programs/Eris/Include/nn/pcm/pcm_Api\.h$", line) != None:
                    print "skip " + line
                elif re.search(r"Programs/Eris/Include/nn/fgm/fgm_Debugger\.h$", line) != None:
                    print "skip " + line
                elif re.search(r"Programs/Chris/Include/nn/htc/htc_Api\.h$", line) != None:
                    print "skip " + line
                elif re.search(r"Programs/Eris/Include/nn/htcs/htcs_Library\.h$", line) != None:
                    print "skip " + line
                elif re.search(r"Programs/Eris/Include/nn/htcs/htcs_Socket\.h$", line) != None:
                    print "skip " + line
                elif re.search(r"Programs/Eris/Include/nn/oe/oe_DebugApis\.h$", line) != None:
                    print "skip " + line
                # libnn_irsensor.a などの直接 .a をリンクするライブラリで sf が使用されるため、誤検出を回避するため sf のヘッダは対象外とする
                elif re.search(r"Programs/Chris/Include/nn/sf/", line) != None:
                    print "skip " + line
                else:
                    if re.match('\s+-\sPrograms', line):
                        # Programs/*/Sources/TargetTools と Programs/*/Sources/Tools 以下のヘッダファイルは対象外とする
                        if not ( re.match('\s+-\sPrograms/Alice/Sources/TargetTools', line) or re.match('\s+-\sPrograms/Alice/Sources/Tools', line) or re.match('\s+-\sPrograms/Chris/Sources/TargetTools', line) or re.match('\s+-\sPrograms/Chris/Sources/Tools', line) or re.match('\s+-\sPrograms/Eris/Sources/TargetTools', line) or re.match('\s+-\sPrograms/Eris/Sources/Tools', line) or re.match('\s+-\sPrograms/Iris/Sources/TargetTools', line) or re.match('\s+-\sPrograms/Iris/Sources/Tools', line) or re.match('\s+-\sPrograms/NintendoWare/Sources/TargetTools', line) or re.match('\s+-\sPrograms/NintendoWare/Sources/Tools', line) ):

                            line = line.strip("    - ")

                            # line の含まれる文字は Siglo ツリー直下からのファイルパスになっている
                            relativeHeaderFilePath = line.rstrip("\n")
                            headerFilePath = normalize_path(SIGLO_ROOT + "/" + line).rstrip("\n")

                            # 特殊な Clang のプラグインが必要なため、指定された Clang を使用する。(NX64向けビルド)
                            cmd = normalize_path(clang_root_dir) + "\\nx\\aarch64\\bin\\clang.exe" + " -S -fplugin=NXMangledNamePrinter.dll -Xclang -plugin-arg-nx-mangled-names -Xclang -main-only -Xclang -plugin-arg-nx-mangled-names -Xclang -no-print-loc  -x c++ -std=gnu++14 -fno-exceptions   -Wstrict-aliasing -Wover-aligned -I" + normalized_siglo_root_path + "\\Programs\\Iris\\Include -I" + normalized_siglo_root_path + "\\Programs\\Iris\\Outputs\\Include -I" + normalized_siglo_root_path + "\\Programs\\Eris\\Include -I" + normalized_siglo_root_path + "\\Programs\\Eris\\Outputs\\Include -I" + normalized_siglo_root_path + "\\Programs\\Chris\\Include -I" + normalized_siglo_root_path + "\\Programs\\Chris\\Outputs\\Include -I" + normalized_siglo_root_path + "\\Programs\\Alice\\Include -I" + normalized_siglo_root_path + "\\Programs\\Alice\\Outputs\\Include -I" + normalized_siglo_root_path + "\\Common\\Configs\\Targets\\NX-NXFP2-a64\\Include -I" + normalized_siglo_root_path + "\\Programs\\NintendoWare\\Include -I" + normalized_siglo_root_path + "\\Externals\\RapidJSON\\include -I" + normalized_siglo_root_path + "\\Externals\\glv\\siglo\\engineOnGfx\\include -I" + normalized_siglo_root_path + "\\Externals\\glv\\siglo\\extension\\include -I" + normalized_siglo_root_path + "\\Externals\\glv\\GLV -fno-common -mno-implicit-float -fno-vectorize -fno-short-enums -ffunction-sections -fdata-sections -fPIC -g -mcpu=cortex-a57+fp+simd+crypto+crc  -O0 -fno-omit-frame-pointer -D \"NN_NINTENDO_SDK\" -D \"NN_SDK_BUILD_RELEASE\" -fno-strict-aliasing -Wno-deprecated-declarations " + " -c " + headerFilePath
                            nx64_proc = subprocess.Popen(cmd, stderr=subprocess.PIPE, stdout=subprocess.PIPE)
                            nx64_stdout_value, nx64_stderr_value = nx64_proc.communicate()
                            stdout_value = re.sub(r'\r', "", nx64_stdout_value)

                            # 特殊な Clang のプラグインが必要なため、指定された Clang を使用する。(NX32向けビルド)
                            cmd = normalize_path(clang_root_dir) + "\\nx\\armv7l\\bin\\clang.exe" + " -S -fplugin=NXMangledNamePrinter.dll -Xclang -plugin-arg-nx-mangled-names -Xclang -main-only -Xclang -plugin-arg-nx-mangled-names -Xclang -no-print-loc  -x c++ -std=gnu++14 -fno-exceptions   -Wstrict-aliasing -Wover-aligned -I" + normalized_siglo_root_path + "\\Programs\\Iris\\Include -I" + normalized_siglo_root_path + "\\Programs\\Iris\\Outputs\\Include -I" + normalized_siglo_root_path + "\\Programs\\Eris\\Include -I" + normalized_siglo_root_path + "\\Programs\\Eris\\Outputs\\Include -I" + normalized_siglo_root_path + "\\Programs\\Chris\\Include -I" + normalized_siglo_root_path + "\\Programs\\Chris\\Outputs\\Include -I" + normalized_siglo_root_path + "\\Programs\\Alice\\Include -I" + normalized_siglo_root_path + "\\Programs\\Alice\\Outputs\\Include -I" + normalized_siglo_root_path + "\\Common\\Configs\\Targets\\NX-NXFP2-a32\\Include -I" + normalized_siglo_root_path + "\\Programs\\NintendoWare\\Include -I" + normalized_siglo_root_path + "\\Externals\\RapidJSON\\include -I" + normalized_siglo_root_path + "\\Externals\\glv\\siglo\\engineOnGfx\\include -I" + normalized_siglo_root_path + "\\Externals\\glv\\siglo\\extension\\include -I" + normalized_siglo_root_path + "\\Externals\\glv\\GLV -fno-common -mno-implicit-float -fno-vectorize -fno-short-enums -ffunction-sections -fdata-sections -fPIC -g -mcpu=cortex-a57 -mfpu=crypto-neon-fp-armv8 -mfloat-abi=hard  -O0 -fno-omit-frame-pointer -D \"NN_NINTENDO_SDK\" -D \"NN_SDK_BUILD_RELEASE\" -fno-strict-aliasing -Wno-deprecated-declarations " + " -c " + headerFilePath
                            nx32_proc = subprocess.Popen(cmd, stderr=subprocess.PIPE, stdout=subprocess.PIPE)
                            nx32_stdout_value, nx32_stderr_value = nx32_proc.communicate()
                            stdout_value += re.sub(r'\r', "", nx32_stdout_value)

                            # 完全性を満たさないヘッダをかけると正しくない情報が出力されることがあるので、出力対象から除外する
                            # Programs/Eris/Include/nn/btm/system/btm_Result.system.h のような、別のヘッダからインクルードされることを前提とした
                            # 完全性を満たさないヘッダはあり得るため、エラーが発生することは許容しなければいけない
                            if nx64_proc.returncode == 0 and nx32_proc.returncode == 0:
                                # 出力が空ならば、シンボルが存在しないヘッダとなる。
                                # バンドル内に存在するヘッダがすべてそのようなヘッダだと、空のタグが書かれてしまうので、それを防止する必要がある。
                                if stdout_value != "":
                                    symbol_name_list = stdout_value.split("\n")
                                    for symbol_name in symbol_name_list:
                                        # 削除する必要がある特殊シンボル
                                        # BundleRules_PerformanceEvaluationKit_NX_Files
                                        # から
                                        # _ZN2nn3fgm8DebuggerC1Ev
                                        # _ZN2nn3fgm8DebuggerD1Ev
                                        # を取り除く
                                        if symbol_name == "_ZN2nn3fgm8DebuggerC1Ev" or symbol_name == "_ZN2nn3fgm8DebuggerD1Ev":
                                            if bundle_id_name == "BundleRules_PerformanceEvaluationKit_NX_Files":
                                                symbol_name = ""

                                        # BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private (NX Addon 0.12.x)
                                        # BundleDefinitions_NX_VideoInterface_Private (NX Addon 1.x)
                                        # から
                                        # _ZN2nn2vi20GetDisplayResolutionEPiS1_PKNS0_7DisplayE
                                        # _ZN2nn2vi18SetLayerVisibilityEPNS0_5LayerEb
                                        # _ZN2nn2vi17SetDisplayEnabledEPNS0_7DisplayEb
                                        # _ZN2nn2vi13SetLayerAlphaEPNS0_5LayerEf
                                        # を取り除く
                                        if symbol_name == "_ZN2nn2vi20GetDisplayResolutionEPiS1_PKNS0_7DisplayE" or symbol_name == "_ZN2nn2vi18SetLayerVisibilityEPNS0_5LayerEb" or symbol_name == "_ZN2nn2vi17SetDisplayEnabledEPNS0_7DisplayEb" or symbol_name == "_ZN2nn2vi13SetLayerAlphaEPNS0_5LayerEf":
                                            if bundle_id_name == "BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private":
                                                symbol_name = ""
                                            elif bundle_id_name == "BundleDefinitions_NX_VideoInterface_Private":
                                                symbol_name = ""

                                        # libcurl.a 内部で使用されているプライベートAPIを、すべてのバンドルから一律で削除する (SIGLO-66229)
                                        if symbol_name == "_ZN2nn3nsd9ResolveExEPNS0_4FqdnERKS1_" or symbol_name == "nnsocketCancel" or symbol_name == "nnsocketGetHostByNameCancel" or symbol_name == "nnsocketRequestCancelHandle":
                                            symbol_name =""

                                        if symbol_name != "":
                                            if symbol_name not in symbol_name_list_uniq:
                                                symbol_name_list_uniq.append(symbol_name)

                            else:
                                print "=========================\n"
                                print headerFilePath + "\n"
                                print "----------\n"
                                print "NX64 error: %s\n" % nx64_proc.returncode
                                print nx64_stderr_value + "\n"
                                print "NX32 error: %s\n" % nx32_proc.returncode
                                print nx32_stderr_value + "\n"
                                print "=========================\n"

        if len(symbol_name_list_uniq) != 0:
            filehandle.write("    <api>\n")
            filehandle.write("        <id>%s%s</id>\n" % (sdk_version, bundle_id_name))
            filehandle.write("        <title>%s%s</title>\n" % (sdk_version, bundle_id_name))
            filehandle.write("        <xpath>/ProgramInfo/SdkVersion[ starts-with(., '%s' ) ]/following-sibling::UnresolvedApiList/UnresolvedApi/ApiName[" % (sdk_version))
            print_symbol_name = symbol_name_list_uniq.pop(0)
            private_api_list.write("%s\n" % print_symbol_name)
            filehandle.write(".='%s'" % print_symbol_name)
            if is_generate_test_file:
                test_filehandle = open(bundle_id_name + ".S", "w")
                test_filehandle.write("    .section .text, \"ax\"\n")
                test_filehandle.write("    .align   2\n")
                test_filehandle.write("    .global  nnMain\n")
                test_filehandle.write("    .type    nnMain, @function\n")
                test_filehandle.write("nnMain:\n")
                test_filehandle.write("    bl      %s\n" % print_symbol_name)
                test_filehandle.write("    .size   nnMain, [. - nnMain]\n")
                test_filehandle.close()
            for print_symbol_name in symbol_name_list_uniq:
                private_api_list.write("%s\n" % print_symbol_name)
                filehandle.write(" or .='%s'" % print_symbol_name)

            filehandle.write("]</xpath>\n")
            real_bundle_file_name = bundle_file_name.replace('_', '/')
            filehandle.write("        <memo>Integrate/Packages/%s.bundle.yml</memo>\n" % real_bundle_file_name)
            filehandle.write("        <source>program-info</source>\n")
            filehandle.write("        <error_display_allowed>true</error_display_allowed>\n")
            filehandle.write("        <display_name>%s%s</display_name>\n" % (sdk_version, bundle_id_name))
            filehandle.write("    </api>\n")

    filehandle.write("</api-list>" + "\n")
    filehandle.close()
    private_api_list.close()


def main(input_file, sdk_version, is_generate_test_file):
    """
    Args:
        input_file:  リストを作成したいパッケージの一覧ファイル。
        sdk_version: リストのチェック対象にしたい SDK のバージョン (例えば 1.x 系なら "1_")
        is_generate_test_file : テスト用の .S ファイルを生成するか否か
    """

    # 引数はパッケージファイルの yml ファイルであり、これからバンドルファイルを抽出する
    # ただし、パッケージに存在しないがリストに追加したいバンドル、除外したいバンドルはここで指定しておく
    bundle_file_list = [normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleDefinitions/NX/OeReportUserIsActive.bundle.yml"), normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleDefinitions/NX/OeDisableAutoSleep.bundle.yml")]
    # v1.4 ブランチと、develop(NX Addon 3.0.0 以降) でバンドルファイルの構成が変わっているので、両方をサポートする。
    ignore_bundle_file_list = [normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleRules/Generic/Private/OceanKit/system.bundle.yml"), normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleRules/NX/Private/OceanKit/system.bundle.yml"), normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleRules/NX/Private/OceanKitFiles/OceanKitFiles.bundle.yml"), normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleRules/OceanKit/Generic/Files.system.bundle.yml"), normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleRules/OceanKit/NX/Files.system.bundle.yml"), normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleRules/OceanKitFiles/NX/OceanKitFiles.bundle.yml")]

    packageFiles = open(input_file, "r")
    package_file_list = packageFiles.readlines()
    packageFiles.close()

    for packeage_file in package_file_list:
        packageFile = open(normalize_path(SIGLO_ROOT + "/" + packeage_file).rstrip("\n"), "r")
        lines = packageFile.readlines()
        packageFile.close()

        for line in lines:
            if re.search("\.bundle\.yml$", line) != None:
                line = re.sub(r'\s+-\s', "", line)
                # line の含まれる文字は Siglo ツリー直下からのファイルパスになっている
                bundle_file_path = normalize_path(SIGLO_ROOT + "/" + line).rstrip("\n")
                bundle_file_list.append(bundle_file_path)

    # リストの順序を変えないために、重複バンドルは for で削除する
    bundle_file_list_uniq = []
    for x in bundle_file_list:
        if x not in bundle_file_list_uniq and x not in ignore_bundle_file_list:
            bundle_file_list_uniq.append(x)

    bundle_to_api_list(bundle_file_list_uniq, sdk_version, is_generate_test_file)


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--sdk', default="1_", help='Set sdk version (e.g. "1_")')
    parser.add_argument('--input', help='Package file list file')
    parser.add_argument('--clang', help='clang directory path')
    parser.add_argument('--gen-test-file', action='store_true')
    args = parser.parse_args()

    sdk_version = args.sdk
    input_file = args.input
    clang_root_dir = args.clang

    is_generate_test_file = args.gen_test_file

    main(input_file, sdk_version, is_generate_test_file)
