﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Management.Automation;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.DotNetLocalizer
{
    [Cmdlet(VerbsCommon.New, "SatelliteAssembly")]
    public class NewSatelliteAssemblyCommand : PSCmdlet
    {
        [Parameter(Mandatory = true,
                   Position = 0)]
        public string ApplicationBase { get; set; }

        [Parameter(Mandatory = true,
                   Position = 1)]
        [AllowNull]
        [AllowEmptyCollection]
        public LocalizationItem[] LocalizeItem { get; set; }

        [Parameter]
        public string PrivateBinPath { get; set; }

        [Parameter]
        public SwitchParameter FillDllWithTemporary { get; set; }

        protected override void ProcessRecord()
        {
            var applicationBase = GetUnresolvedProviderPathFromPSPath(ApplicationBase);
            if (!Directory.Exists(applicationBase))
            {
                ThrowTerminatingError(new ErrorRecord(new DirectoryNotFoundException(), "DirectoryNotFound", ErrorCategory.InvalidArgument, ApplicationBase));
            }

            DllGeneratorInvoker.Invoke(
                applicationBase,
                PrivateBinPath,
                FillDllWithTemporary.IsPresent,
                LocalizeItem ?? DotNetLocalizer.LocalizationItem.EmptyArray);
        }
    }
}
