﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Management.Automation;

namespace Nintendo.DotNetLocalizer
{
    [Cmdlet(VerbsData.Import, "LocalizationItemXml")]
    public class ImportLocalizationItemXmlCommand : PSCmdlet
    {
        [Parameter(Mandatory = true,
                   Position = 0)]
        public string Path { get; set; }

        protected override void ProcessRecord()
        {
            var providerPath = GetUnresolvedProviderPathFromPSPath(Path);
            if (!File.Exists(providerPath))
            {
                ThrowTerminatingError(new ErrorRecord(new FileNotFoundException(), "FileNotFound", ErrorCategory.InvalidArgument, Path));
            }

            WriteObject(LocalizeItemXmlSerializer.ReadXml(providerPath), true);
        }
    }
}
