﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

namespace MakeDictionarySource
{
    /// <summary>
    /// プログラムのエントリポイント関連のクラスです。
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            MakeDictionaryCppArgs opt = new MakeDictionaryCppArgs();

            // コマンドライン引数のパース
            try
            {
                if (!opt.ParseArgs(args))
                {
                    return;
                }
            }
            catch
            {
                Environment.ExitCode = 1;
                return;
            }
            MakeDictionaryCppParams param = opt.Params;

            // ファイル生成処理
            try
            {
                if (param.OutputCppPath != null)
                {
                    // DictionaryCpp を生成して、出力ファイルに書き込み
                    DictionaryCpp cpp;
                    if (param.Dummy || param.InputPath == null)
                    {
                        cpp = new DictionaryCpp(param.ModuleName, param.AdditionalInclude);
                    }
                    else
                    {
                        cpp = new DictionaryCpp(param.ModuleName, param.AdditionalInclude, param.InputPath);
                    }

                    using (var fs = new FileStream(param.OutputCppPath, FileMode.Create))
                    {
                        // BOM あり UTF-8 で書き込み
                        using (var writer = new StreamWriter(fs, new UTF8Encoding(true)))
                        {
                            writer.Write(cpp.ToString());
                        }
                    }
                }

                if (param.OutputHeaderPath != null)
                {
                    // DictionaryHeader を生成して、出力ファイルに書き込み
                    DictionaryHeader header = new DictionaryHeader(param.ModuleName, param.AdditionalInclude);
                    using (var fs = new FileStream(param.OutputHeaderPath, FileMode.Create))
                    {
                        // BOM あり UTF-8 で書き込み
                        using (var writer = new StreamWriter(fs, new UTF8Encoding(true)))
                        {
                            writer.Write(header.ToString());
                        }
                    }
                }
            }
            catch (IOException e)
            {
                Console.WriteLine(e);
            }
        }
    }
}
