﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

namespace MakeDictionarySource
{
    /// <summary>
    /// DictionaryHeader ファイルの文字列データを生成するためのクラスです。
    /// </summary>
    class DictionaryHeader
    {
        private readonly string m_AdditionalInclude;
        private readonly string m_ModuleName;
        public string ModuleName
        {
            get { return m_ModuleName; }
        }

        /// <summary>
        /// モジュール名をもとに Dictionary ヘッダファイルの中身を生成するコンストラクタです。
        /// </summary>
        /// <param name="moduleName">モジュール名</param>
        public DictionaryHeader(string moduleName, string additionalInclude)
        {
            if (moduleName == null)
            {
                throw new ArgumentNullException();
            }

            m_ModuleName = moduleName;
            m_AdditionalInclude = additionalInclude;
        }

        /// <summary>
        /// ヘッダファイルの文字列データを返します。
        /// </summary>
        /// <returns>ヘッダファイルの文字列データ</returns>
        public override string ToString()
        {
            string includeExpression = Utils.GetIncludeExpression(m_AdditionalInclude);
            string functionName = Utils.GetFunctionName(ModuleName);
            string macroName = Utils.GetMacroName(ModuleName);
            return String.Format(HeaderFileFormat, includeExpression, functionName, macroName);
        }

        // ソースコードのテンプレート文字列
        // {0}: 追加のインクルード
        // {1}: メソッド名
        // {2}: マクロ名
        private const string HeaderFileFormat = @"/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/diag/detail/diag_DetailTranslation.h>
{0}

/*
* @file
* @brief    アサート・ログメッセージ翻訳用の辞書にアクセスする API を宣言します。
*           このファイルは自動生成されたものなので、変更しないでください。
*/

namespace nn {{
namespace diag {{
namespace detail {{
    /*
    * アサート・ログメッセージ翻訳機能の内部実装で使うメソッドです。
    * 翻訳機能の利用者は、このメソッドを直接呼び出さないでください。
    */
    const char* {1}(const char* str);
}}
}}
}}


/*
* @brief    アサート・ログメッセージ用の文字列を翻訳します。
*
* @param[in]    string  翻訳前の文字列リテラル
* @return               翻訳後の UTF-8 文字列
*/
#define {2}(string) NN_DETAIL_DIAG_SDK_TEXT(nn::diag::detail::{1}, string)
";
    }
}
