:: ---------------------------------------------------------------------------
::  Copyright (C)Nintendo All rights reserved.
::
::  These coded instructions, statements, and computer programs contain proprietary
::  information of Nintendo and/or its licensed developers and are protected by
::  national and international copyright laws. They may not be disclosed to third
::  parties or copied or duplicated in any form, in whole or in part, without the
::  prior written consent of Nintendo.
::
::  The content herein is highly confidential and should be handled accordingly.
:: ---------------------------------------------------------------------------

@echo off

setlocal

set REPOSITORY_ROOT=%~dp0..\..\..\..\
set INSTALL_DIRECTORY="%~1"

:: ---------------------------------------------------------------------------
:: Install hooks
:: ---------------------------------------------------------------------------
set CODING_CHECKER_SRC_ROOT="%~dp0"

set CODING_CHECKER_OUT_ROOT="%REPOSITORY_ROOT%Integrate\Outputs\AnyCPU\Tools\CodingChecker\"
if not exist %CODING_CHECKER_OUT_ROOT% goto :error_no_build_out_dir

:: CommitContentChecker
call :install ^
    "%CODING_CHECKER_OUT_ROOT%CommitContentChecker\Release\CommitContentChecker.exe" ^
    "%CODING_CHECKER_SRC_ROOT%CommitContentChecker\pre-commit.contentcheck" ^
    "%CODING_CHECKER_SRC_ROOT%CodingCheckerTargetExtensions.list"

if ERRORLEVEL 1 goto error_copy_failed

:: CommitLogChecker
call :install ^
    "%CODING_CHECKER_OUT_ROOT%CommitLogChecker\Release\CommitLogChecker.exe" ^
    "%CODING_CHECKER_SRC_ROOT%CommitLogChecker\commit-msg.logcheck" ^
    "%CODING_CHECKER_SRC_ROOT%CommitLogChecker\JiraKeyList.list"

if ERRORLEVEL 1 goto error_copy_failed

:: PrePushChecker
:: Note: pre-push hook script will be copied by Integrate\Repository\Tools\GitExternalStorage\setup.cmd
call :install ^
    "%CODING_CHECKER_OUT_ROOT%PushChecker\Release\PushChecker.exe"

if ERRORLEVEL 1 goto error_copy_failed

:: CodingCheckerUtil
call :install ^
    "%CODING_CHECKER_OUT_ROOT%CodingCheckerUtil\Release\CodingCheckerUtil.dll"

if ERRORLEVEL 1 goto error_copy_failed

:: ToolFoundation
call :install ^
    "%CODING_CHECKER_OUT_ROOT%CommitContentChecker\Release\Nintendo.ToolFoundation.CommandLine.dll"

if ERRORLEVEL 1 goto error_copy_failed

:: ---------------------------------------------------------------------------
:: Success and exit
:: ---------------------------------------------------------------------------
exit /b 0

:: ---------------------------------------------------------------------------
:: Error and exit
:: ---------------------------------------------------------------------------

:error_copy_failed
echo ASSERTION FAILURE: Failed to copy CodingChecker files into %INSTALL_DIRECTORY%.
exit /b 1

:error_no_build_out_dir
echo ASSERTION FAILURE: Output directory of CodingChecker not found.
exit /b 1

:: ---------------------------------------------------------------------------
:: Procedures
:: ---------------------------------------------------------------------------
:install
for %%I in (%*) do (
    xcopy /b /i /y /q %%I %INSTALL_DIRECTORY% >nul
    if ERRORLEVEL 1 exit /b 1
)
exit /b 0

