﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace ApiLinkRewriter
{
    //
    //    COMMAND [--html-dir <directory>] [--input-file <inputFiles>] --pre-api-url <url> --tag-info-xml <tagFiles> [--save-as] [--detail] [--quiet]
    //
    //
    //       --html-dir  <directory>        HTML があるディレクトリ。
    //                                      ここ以下の html が対象となる。
    //                                      --input-file と両方指定することは出来ない。
    //
    //       --input-file  <inputFiles>     一つのファイルを対象にする場合。
    //                                      --html-dir と両方指定することは出来ない。
    //                                      複数指定が可能。( --input-file "a.html,b.html" のように )
    //
    //       --pre-api-url  <url>           APIリファレンス群への位置。このファイルの位置から。
    //                                      "../../" のように指定する。(最後の"/"も必要)
    //                                      ここに、各パッケージ固有のパスが加わる。
    //
    //       --tag-info-xml  <tagFiles>     タグファイル
    //                                      省略した場合、タグファイル探索は行わない
    //                                      複数指定が可能。( --tag-info-xml "tag1.xml,tag2.xml" のように )
    //
    //       --save-as                元ファイルに出力を上書きしない。.output として保存。
    //
    //       --detail                       動作の情報を詳細に表示する。省略可で、省略時は詳細を表示しない。
    //                                      --quiet と両方指定することは出来ない。
    //
    //       --quiet                        動作の情報を表示しない。省略可で、省略時は動作の情報を表示。
    //                                      --detail と両方指定することは出来ない。
    class CommandLineOptions
    {
        [CommandLineOption("html-dir", Description = "Specify the html directory.", DefaultValue = null)]
        public string HtmlDir { get; set; }

        [CommandLineOption("input-file", ConverterName = "SplitArgument", Description = "Specify the input files.( -InputFile \"a.html, b.html\")", DefaultValue = null)]
        public string[] InputFiles { get; set; }

        [CommandLineOption("pre-api-url", Description = "Specify relative path of API reference directory form this directory. It needs last charactor \"/\". (\"../../ \")", IsRequired = true, DefaultValue = "")]
        public string PreApiUrl { get; set; }

        [CommandLineOption("tag-info-xml", ConverterName = "SplitArgument", Description = "Specify the tag files. If it's omitted, this does't search for tag file. It's possible to specify some files.(-TagInfoXml \"tag1.xml, tag2.xml\")", IsRequired = true, DefaultValue = null)]
        public string[] TagInfoXmlFiles { get; set; }

        [CommandLineOption("save-as", Description = "Save as other output files, It doesn't overwrite the files.", DefaultValue = false)]
        public bool SaveAs { get; set; }

        [CommandLineOption("detail", Description = "Show detail process information.", DefaultValue = false)]
        public bool Detail { get; set; }

        [CommandLineOption("quiet", Description = "Specify the Quiet option of Select-String.", DefaultValue = false)]
        public bool Quiet { get; set; }
        /**
         * <summary>コマンドラインオプションで指定された文字列をカンマ区切りで配列にする</summary>
         */
        public string[] SplitArgument(string value, string hoge)
        {
            if (value == null)
            {
                return null;
            }
            return value.Split(',');
        }

    }
}
