﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Update submodules

    .DESCRIPTION
        Run git submodule init, sync, update

    .INPUTS
        Name of submodules
#>


$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\Path"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

& (Get-GitPath) submodule init @args
& (Get-GitPath) submodule sync @args
& (Get-GitPath) submodule update --force @args

exit $LastExitCode
