﻿<#
    Copyright (C)Nintendo. All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
 
    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS

    .DESCRIPTION

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>
[CmdletBinding()]
Param(
    [parameter(Mandatory = $true,
                ValueFromPipeline = $true)]
    [string[]] $Path
)

begin {
    # エラー出力に書き出されたらストップする。
    $ErrorActionPreference = "Stop"

    # ビルド
    & "$Env:SystemRoot/Microsoft.NET/Framework64/v4.0.30319/MSBuild" `
        $sigloRoot/Integrate/Sources/Tools/PlatformCodeFilter/PlatformCodeFilter.sln `
        /m /t:Build "/p:Configuration=Release"

    # ビルドしたモジュールをインポート
    Import-Module $sigloRoot/Integrate/Outputs/AnyCPU/Tools/PlatformCodeFilter/PlatformCodeFilter/Release/PlatformCodeFilter.psd1

    # ソースコードから 特定のプラットフォームを除外する。
    $platformDefine = @{
        # g3d
        ANDROID = 0x0808
        __APPLE__ = 0x1010
        NW_G3D_IS_GL_ES = 0x1818

        # eft
        NW_PLATFORM_SMART_DEVICE = 0x1818

        # snd
        # ANDROID = 0x0808
        NW_PLATFORM_ANDROID = 0x0808
        NW_PLATFORM_IOS = 0x1010
    }
}
process {
    Convert-PlatformCode -Macro $platformDefine -Enable 0xE7E7 -Path $Path
}
