<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Sets the settings for the device for network tests

    .DESCRIPTION
        - Sets the DNS settings for the device
        
#>

param
(
    [string]
    # SDK root directory
    $sigloRoot =
    ($env:NINTENDO_SDK_ROOT | ? { $_ } | % { $_.Trim() }),

    [string]
    # Device's IP address
    $TargetAddress =
    ($env:TARGET_ADDRESS_PATTERN | ? { $_ } | % { $_.Trim() }),

    [string]
    # Test server's IP address
    $HostIpAddress =
    ($env:TESTSERVERIPADDR | ? { $_ } | % { $_.Trim() })
)

# set the custom DNS on the device
& Tools\CommandLineTools\ControlTarget.exe connect
& Tests\Outputs\Win32-v140\Tests\GenDnsNetworkSettings\Develop\GenDnsNetworkSettings.exe --PreferredDns=$HostIpAddress  --AlternateDns=0.0.0.0  --NetSettingsFileIn=$sigloRoot\Tests\Net\Resources\NetworkSettings_OnlyEthernet.txt  --NetSettingsFileOut=$sigloRoot\Tests\Net\Resources\NetworkSettingsForCI_CustomDns.txt
& Tools\CommandLineTools\RunOnTarget.exe ./Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/SettingsManager/Develop/SettingsManager.nsp -- Import "$sigloRoot\Tests\Net\Resources\NetworkSettingsForCI_CustomDns.txt"

# reboot device
& Tools\CommandLineTools\ControlTarget.exe reset --hard --target $TargetAddress
Start-Sleep -s 60
& Tools\CommandLineTools\ControlTarget.exe connect
