<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Write the Package2 for enabling EDEV log by FRCM
#>
[CmdletBinding()]
Param
(
    [string]
    $Package2,
    
    [string]
    $BuildType = 'Develop',
    
    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $KeyType = 'K3' # K1, K2, K3
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../Modules/Runner"
Import-Module "${scriptDirectoryPath}/../../Modules/UsbTarget"

$RcmWriter          = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.exe"
$RcmWriterRcm       = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.$KeyType.rcm"
$RcmWriterRcmOld    = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.$KeyType.old.rcm"
$RcmWriterXml       = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/RcmWriter/Write-Package2.xml"
$RcmWriterAdditionalOptions = ""

if($KeyType -eq 'M2')
{
    $RcmWriterAdditionalOptions = "--old_rcm `"$RcmWriterRcmOld`""
}

$OutputDirectory    = "$(Get-NintendoSdkRootPath)/Integrate/Outputs/RcmWriter"
$OutputConfig       = "$OutputDirectory/RcmWriterConfig.xml"
$OutputPackage2     = "$OutputDirectory/Package2.img"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

if (!(Test-Path $OutputDirectory)) {
    mkdir $OutputDirectory > $null
}

# Test existing files
Test-EnsureExistPath $RcmWriter
Test-EnsureExistPath $RcmWriterRcm
Test-EnsureExistPath $RcmWriterXml
Test-EnsureExistPath $Package2

# Copy files

cp $RcmWriterXml $OutputConfig
cp $Package2 $OutputPackage2

# RcmWriter
Invoke-CriticalCommand "& `"$RcmWriter`" --rcm `"$RcmWriterRcm`" --list `"$OutputConfig`" $RcmWriterAdditionalOptions"
