<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Get BootImageHash from Integrate/Outputs/DumpedBootImages
#>
[CmdletBinding()]
Param
(
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../Modules/Runner"
Import-Module "${scriptDirectoryPath}/../../Modules/UsbTarget"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$sdkRootPath = $(Get-NintendoSdkRootPath)
$yamlDotNetDll = "$sdkRootPath/Externals/Binaries/YamlDotNet-3.0.0/YamlDotNet.dll"
Add-Type -Path $yamlDotNetDll
Import-CsScripts -ModuleName "TargetInitializationUtility/TargetInitializationUtility"  -ReferencedAssemblies $yamlDotNetDll

[CsScripts.TargetInitializationUtility]::GenerateBuildRulesAndScriptsForInitialImage($sdkRootPath)
